/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_4.backend.client.payment;

import com.ericsson.em.m3if.operations.adapter.LinkVerificationCodeAdapter;
import com.ericsson.em.m3if.operations.annotations.IdentityTraceAction;
import com.ericsson.em.m3if.operations.annotations.IdentityTraceAsynchronousHint;
import com.ericsson.em.m3if.operations.annotations.SignedElements;
import com.ericsson.em.m3if.operations.validation.ExtensionTypeLength;
import com.ericsson.em.m3if.products.v1_0.common.ProductIdValue;
import com.ericsson.em.m3if.products.v1_0.common.ProductOfferingIdValue;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.LinkVerificationCode;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsIntegerStringWithinRange;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@IdentityTraceAsynchronousHint(action=IdentityTraceAction.REGISTER, field="transactionId", grouping="paymentcomplete")
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_4/backend/client", name="paymentrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_4/backend/client", name="", propOrder={"transactionId", "accountHolderId", "receivingFRI", "amount", "message", "transmissionCounter", "transactionTimestamp", "externalReferenceId", "extension", "linkVerificationCode", "productId", "productOfferingId"})
@SignedElements(value={"transactionid", "accountholderid", "amount/amount", "amount/currency"})
public class PaymentRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @XmlElement(name="transactionid", type=Long.class, required=true)
    private Long transactionId;
    @NotNull
    @IsIdentity
    @XmlElement(name="accountholderid", type=String.class, required=true)
    private String accountHolderId;
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="receivingfri", type=String.class, required=true)
    private String receivingFRI;
    @Valid
    @NotNull
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    private MoneyDetails amount;
    @Length(max=256)
    @XmlElement(name="message", type=String.class)
    @IsRestrictedString
    private String message;
    @IsIntegerStringWithinRange(min=0)
    @XmlElement(name="transmissioncounter", type=String.class)
    private String transmissionCounter;
    @Valid
    @NotNull
    @XmlElement(name="transactiontimestamp", type=Iso8601DateTime.class, required=true)
    private Iso8601DateTime transactionTimestamp;
    @Length(min=1, max=64)
    @IsExternalReferenceString
    @XmlElement(name="externalreferenceid", type=String.class)
    private String externalReferenceId;
    @Valid
    @ExtensionTypeLength(max=3959)
    @XmlElement(name="extension", type=ExtensionType.class)
    private ExtensionType extension;
    @Valid
    @XmlJavaTypeAdapter(value=LinkVerificationCodeAdapter.class)
    @XmlElement(name="linkverificationcode", type=LinkVerificationCode.class)
    private LinkVerificationCode linkVerificationCode;
    @Valid
    @XmlElement(name="productid", type=ProductIdValue.class)
    private ProductIdValue productId;
    @Valid
    @XmlElement(name="productofferingid", type=ProductOfferingIdValue.class)
    private ProductOfferingIdValue productOfferingId;

    public PaymentRequest() {
    }

    public PaymentRequest(long transactionId, String acctHolderId, String receivingFRI, MoneyDetails amount, String message, String transmissionCounter, Iso8601DateTime transactionTimestamp, String externalReferenceId, ExtensionType extension) {
        this(transactionId, acctHolderId, receivingFRI, amount, message, transmissionCounter, transactionTimestamp, externalReferenceId, extension, null);
    }

    public PaymentRequest(long transactionId, String acctHolderId, String receivingFRI, MoneyDetails amount, String message, String transmissionCounter, Iso8601DateTime transactionTimestamp, String externalReferenceId, ExtensionType extension, LinkVerificationCode linkVerificationCode) {
        this.setTransactionId(transactionId);
        this.setAccountHolderId(acctHolderId);
        this.setReceivingFRI(receivingFRI);
        this.setAmount(amount);
        this.setMessage(message);
        this.setTransmissionCounter(transmissionCounter);
        this.setTransactionTimestamp(transactionTimestamp);
        this.setExternalReferenceId(externalReferenceId);
        this.setExtension(extension);
        this.setLinkVerificationCode(linkVerificationCode);
    }

    public String getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(String receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ExtensionType getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    public String getAccountHolderId() {
        return this.accountHolderId;
    }

    public void setAccountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public String getTransmissionCounter() {
        return this.transmissionCounter;
    }

    public void setTransmissionCounter(String transmissionCounter) {
        this.transmissionCounter = transmissionCounter;
    }

    public Iso8601DateTime getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    public void setTransactionTimestamp(Iso8601DateTime transactionTimestamp) {
        this.transactionTimestamp = transactionTimestamp;
    }

    public String getExternalReferenceId() {
        return this.externalReferenceId;
    }

    public void setExternalReferenceId(String externalReferenceId) {
        this.externalReferenceId = externalReferenceId;
    }

    public LinkVerificationCode getLinkVerificationCode() {
        return this.linkVerificationCode;
    }

    public void setLinkVerificationCode(LinkVerificationCode linkVerificationCode) {
        this.linkVerificationCode = linkVerificationCode;
    }

    public void setLinkVerificationCode(String linkVerificationCode) {
        this.linkVerificationCode = LinkVerificationCode.fromString(linkVerificationCode);
    }

    @Nullable
    public ProductIdValue getProductId() {
        return this.productId;
    }

    public void setProductId(@Nullable ProductIdValue productId) {
        this.productId = productId;
    }

    @Nullable
    public ProductOfferingIdValue getProductOfferingId() {
        return this.productOfferingId;
    }

    public void setProductOfferingId(@Nullable ProductOfferingIdValue productOfferingId) {
        this.productOfferingId = productOfferingId;
    }
}

