/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.serviceprovider.v1_2.common;

import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.v1_0.common.CurrencyCode;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.PreApprovalStatus;
import com.ericsson.em.validators.IsLong;
import com.ericsson.em.validators.IsRestrictedString;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/serviceprovider/v1_2/common", name="preapprovaldetails", propOrder={"preApprovalId", "toFRI", "fromFRI", "fromCurrencyCode", "createdTime", "approvedTime", "expiryTime", "status", "message"})
public class PreApprovalDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @IsLong
    @XmlElement(name="preapprovalid", required=true)
    private Long preApprovalId;
    @Valid
    @NotNull
    @XmlElement(name="tofri", required=true)
    private FRIValue toFRI;
    @Valid
    @NotNull
    @XmlElement(name="fromfri", required=true)
    private FRIValue fromFRI;
    @Valid
    @NotNull
    @XmlElement(name="fromcurrency", required=true)
    private CurrencyCode fromCurrencyCode;
    @NotNull
    @Valid
    @IsDateTimeValue
    @XmlElement(name="createdtime", type=DateTimeValue.class, required=true)
    private DateTimeValue createdTime;
    @Valid
    @IsDateTimeValue
    @XmlElement(name="approvedtime", type=DateTimeValue.class, required=false)
    private DateTimeValue approvedTime;
    @Valid
    @IsDateTimeValue
    @XmlElement(name="expirytime", type=DateTimeValue.class, required=false)
    private DateTimeValue expiryTime;
    @Valid
    @NotNull
    @XmlElement(name="status", required=true)
    private PreApprovalStatus status;
    @NotNull
    @IsRestrictedString
    @XmlElement(name="message", required=true)
    private String message;

    public PreApprovalDetails() {
    }

    PreApprovalDetails(Long preApprovalId, String fromFRI, String toFRI, CurrencyCode fromCurrencyCode, DateTime createdTime, DateTime approvedTime, DateTime expiryTime, PreApprovalStatus status, String message) {
        this.setPreApprovalId(preApprovalId);
        this.setFromFRI(fromFRI);
        this.setToFRI(toFRI);
        this.setFromCurrencyCode(fromCurrencyCode);
        this.setCreatedTime(createdTime);
        this.setApprovedTime(approvedTime);
        this.setExpiryTime(expiryTime);
        this.setStatus(status);
        this.setMessage(message);
    }

    public Long getPreApprovalId() {
        return this.preApprovalId;
    }

    public void setPreApprovalId(Long preApprovalId) {
        this.preApprovalId = preApprovalId;
    }

    public String getToFRI() {
        return this.toFRI == null ? null : this.toFRI.getValueAsString();
    }

    public void setToFRI(String toFRI) {
        this.toFRI = FRIValue.fromString(toFRI);
    }

    public String getFromFRI() {
        return this.fromFRI == null ? null : this.fromFRI.getValueAsString();
    }

    public void setFromFRI(String fromFRI) {
        this.fromFRI = FRIValue.fromString(fromFRI);
    }

    public CurrencyCode getFromCurrencyCode() {
        return this.fromCurrencyCode;
    }

    public void setFromCurrencyCode(CurrencyCode fromCurrencyCode) {
        this.fromCurrencyCode = fromCurrencyCode;
    }

    public DateTime getCreatedTime() {
        return DateTimeValue.asDateTime(this.createdTime).orElse(null);
    }

    public void setCreatedTime(DateTime createdTime) {
        this.createdTime = DateTimeValue.fromDateTime(createdTime).orElse(null);
    }

    public DateTime getApprovedTime() {
        return DateTimeValue.asDateTime(this.approvedTime).orElse(null);
    }

    public void setApprovedTime(DateTime approvedTime) {
        this.approvedTime = DateTimeValue.fromDateTime(approvedTime).orElse(null);
    }

    public DateTime getExpiryTime() {
        return DateTimeValue.asDateTime(this.expiryTime).orElse(null);
    }

    public void setExpiryTime(DateTime expiryTime) {
        this.expiryTime = DateTimeValue.fromDateTime(expiryTime).orElse(null);
    }

    public PreApprovalStatus getStatus() {
        return this.status;
    }

    public void setStatus(PreApprovalStatus status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

