/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.rds.v1_0.reference;

import com.ericsson.em.validation.Validation;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;

public class AccountDetailsRecord
implements Serializable {
    private static final long serialVersionUID = 3348525375351132290L;
    @Valid
    @NotNull
    private final String accountId;
    @Valid
    @NotNull
    private final String accountStatus;
    @Valid
    @Size(max=64)
    private final @Valid @Size(max=64) String accountProfileName;

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountStatus() {
        return this.accountStatus;
    }

    public String getAccountProfileName() {
        return this.accountProfileName;
    }

    AccountDetailsRecord(Builder builder) {
        this.accountId = builder.accountId;
        this.accountProfileName = builder.accountProfileName;
        this.accountStatus = builder.accountStatus;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String accountId;
        private String accountProfileName;
        private String accountStatus;

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountProfileName(String accountProfileName) {
            this.accountProfileName = accountProfileName;
            return this;
        }

        public Builder accountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
            return this;
        }

        public AccountDetailsRecord build() {
            return Validation.validate(new AccountDetailsRecord(this));
        }
    }
}

