/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.rds.v1_0.additionalinformation;

import com.ericsson.em.validation.Validation;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;

public class AdditionalInformationRecord
implements Serializable {
    private static final long serialVersionUID = -3617397873322930365L;
    @Valid
    @NotNull
    private final Long fkNameId;
    @NotNull
    @Length(min=1, max=128)
    @IsRestrictedString
    private final String value;

    AdditionalInformationRecord(String value, Long fkNameId) {
        this.value = value;
        this.fkNameId = fkNameId;
    }

    public static AdditionalInformationRecord create(String value, Long fkNameId) {
        return Validation.validate(new AdditionalInformationRecord(value, fkNameId));
    }

    public Long getFkNameId() {
        return this.fkNameId;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalInformationRecord that = (AdditionalInformationRecord)o;
        return this.fkNameId.equals(that.fkNameId) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.fkNameId, this.value);
    }

    public String toString() {
        return "AdditionalInformationRecord{fkNameId=" + this.fkNameId + ", value='" + this.value + "'}";
    }
}

