/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_1.common;

import com.ericsson.em.m3if.v1_0.common.CompanyType;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.NatureOfBusiness;
import com.ericsson.em.validators.IsAddress;
import com.ericsson.em.validators.IsEmail;
import com.ericsson.em.validators.IsGeographicalName;
import com.ericsson.em.validators.IsIsoPhoneNumber;
import com.ericsson.em.validators.IsPersonalName;
import com.ericsson.em.validators.IsPostalCode;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_1/common", name="companyinformation", propOrder={"companyId", "companyName", "registrationNumber", "phoneNumber", "faxNumber", "email", "streetName", "addressLine1", "postalCode", "city", "province", "country", "type", "natureOfBusiness", "dateOfIncorporation", "dateOfCommencement"})
public class CompanyInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="companyid")
    private Long companyId;
    @IsPersonalName
    @Length(max=250)
    @XmlElement(name="companyname")
    private String companyName;
    @IsRestrictedString
    @Length(max=32)
    @XmlElement(name="registrationnumber")
    private String registrationNumber;
    @IsIsoPhoneNumber
    @Length(max=32)
    @XmlElement(name="phonenumber")
    private String phoneNumber;
    @IsIsoPhoneNumber
    @Length(max=32)
    @XmlElement(name="faxnumber")
    private String faxNumber;
    @IsEmail
    @Length(max=256)
    @XmlElement(name="email")
    private String email;
    @IsAddress
    @Length(max=128)
    @XmlElement(name="streetname")
    private String streetName;
    @IsAddress
    @Length(max=128)
    @XmlElement(name="addressline1")
    private String addressLine1;
    @IsPostalCode
    @Length(max=64)
    @XmlElement(name="postalcode")
    private String postalCode;
    @IsGeographicalName
    @Length(max=64)
    @XmlElement(name="city")
    private String city;
    @IsGeographicalName
    @Length(max=64)
    @XmlElement(name="province")
    private String province;
    @IsGeographicalName
    @Length(max=64)
    @XmlElement(name="country")
    private String country;
    @Valid
    @XmlElement(name="type")
    private CompanyType type;
    @Valid
    @XmlElement(name="natureofbusiness")
    private NatureOfBusiness natureOfBusiness;
    @Valid
    @XmlElement(name="dateofincorporation")
    private Iso8601DateTime dateOfIncorporation;
    @Valid
    @XmlElement(name="dateofcommencement")
    private Iso8601DateTime dateOfCommencement;

    public Long getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getProvince() {
        return this.province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getType() {
        return this.type != null ? this.type.getValueAsString() : null;
    }

    public void setType(String type) {
        this.type = CompanyType.fromString(type);
    }

    public String getNatureOfBusiness() {
        return this.natureOfBusiness != null ? this.natureOfBusiness.getValueAsString() : null;
    }

    public void setNatureOfBusiness(String natureOfBusiness) {
        this.natureOfBusiness = NatureOfBusiness.fromString(natureOfBusiness);
    }

    public Iso8601DateTime getDateOfIncorporation() {
        return this.dateOfIncorporation;
    }

    public void setDateOfIncorporation(Iso8601DateTime dateOfIncorporation) {
        this.dateOfIncorporation = dateOfIncorporation;
    }

    public Iso8601DateTime getDateOfCommencement() {
        return this.dateOfCommencement;
    }

    public void setDateOfCommencement(Iso8601DateTime dateOfCommencement) {
        this.dateOfCommencement = dateOfCommencement;
    }
}

