/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.provisioning.v1_0.updateaccountholdercitizenship;

import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMultilineRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import iso.std.iso._20022.tech.xsd.CitizenshipInformation;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="updateaccountholdercitizenshiprequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/provisioning/v1_0", name="", propOrder={"identity", "citizenships", "reason"})
public class UpdateAccountHolderCitizenshipRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @XmlElement(name="identity")
    @IsIdentity
    private String identity;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="citizenships")
    @XmlElements(value={@XmlElement(name="citizenship", type=CitizenshipInformation.class)})
    private List<CitizenshipInformation> citizenships;
    @Length(max=512)
    @IsMultilineRestrictedString
    @XmlElement(name="reason")
    private String reason;

    public UpdateAccountHolderCitizenshipRequest() {
    }

    public UpdateAccountHolderCitizenshipRequest(String identity) {
        this.identity = identity;
    }

    public UpdateAccountHolderCitizenshipRequest(String identity, List<CitizenshipInformation> citizenships) {
        this.identity = identity;
        this.citizenships = citizenships;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public List<CitizenshipInformation> getCitizenships() {
        if (this.citizenships == null) {
            return Collections.emptyList();
        }
        return this.citizenships;
    }

    public void setCitizenships(List<CitizenshipInformation> citizenships) {
        this.citizenships = citizenships;
    }

    public boolean containsCitizenships() {
        return this.citizenships != null && !this.citizenships.isEmpty();
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean hasReason() {
        return this.reason != null;
    }
}

