/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.payee.v1_0.common;

import com.ericsson.em.m3if.v1_0.common.IdentityType;
import com.ericsson.em.validators.IsPersonalName;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.NotBlank;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/payee/v1_0/common", name="payeeinfo", propOrder={"firstName", "lastName", "externalId", "identityType", "identityValue"})
public class PayeeInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsPersonalName
    @XmlElement(name="firstname")
    private String firstName;
    @IsPersonalName
    @XmlElement(name="lastname")
    private String lastName;
    @IsRestrictedString
    @XmlElement(name="externalid")
    private String externalId;
    @Valid
    @NotNull
    @XmlElement(name="identitytype", type=IdentityType.class, required=true)
    private IdentityType identityType;
    @Valid
    @NotBlank
    @IsRestrictedString
    @XmlElement(name="identityvalue", required=true)
    private String identityValue;

    public PayeeInfo() {
    }

    public PayeeInfo(String firstName, String lastName, String externalId, IdentityType identityType, String identityValue) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.externalId = externalId;
        this.identityType = identityType;
        this.identityValue = identityValue;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String toString() {
        return "PayeeInfo [identityValue=" + this.identityValue + ", identityType=" + String.valueOf((Object)this.identityType) + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", externalId=" + this.externalId + "]";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identityType, this.identityValue});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PayeeInfo payeeInfo = (PayeeInfo)o;
        return this.identityType == payeeInfo.identityType && this.identityValue.equals(payeeInfo.identityValue);
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public IdentityType getIdentityType() {
        return this.identityType;
    }

    public void setIdentityType(IdentityType identityType) {
        this.identityType = identityType;
    }

    public String getIdentityValue() {
        return this.identityValue;
    }

    public void setIdentityValue(String identityValue) {
        this.identityValue = identityValue;
    }
}

