/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.operations.validation.impl;

import com.ericsson.em.m3if.operations.validation.NotFutureDate;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.validators.IsDateString;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.time.LocalDateTime;
import java.time.LocalTime;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

public class NotFutureDateValidator
implements ConstraintValidator<NotFutureDate, Object> {
    private IsDateString.DATE_FORMAT format;

    @Override
    public void initialize(NotFutureDate paramA) {
        this.format = paramA.format();
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (value instanceof XMLGregorianCalendar) {
            return !((XMLGregorianCalendar)value).toGregorianCalendar().toZonedDateTime().toLocalDateTime().with(LocalTime.MIN).isAfter(LocalDateTime.now());
        }
        if (value instanceof Iso8601DateTime && value.toString() != null) {
            return !((Iso8601DateTime)value).getValueAsLocalDateTime().with(LocalTime.MIN).isAfter(LocalDateTime.now());
        }
        if (value instanceof String) {
            return !this.isFutureDate((String)value);
        }
        return true;
    }

    private boolean isFutureDate(String inputDate) {
        try {
            return DateTimeFormat.forPattern(this.format.getFormat()).parseLocalDate(inputDate).toDateTimeAtStartOfDay().isAfter(DateTime.now());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

