/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v2_5.common;

import com.ericsson.em.m3if.financial.v1_0.common.ApprovalsRequired;
import com.ericsson.em.m3if.financial.v1_0.common.ChargeDetail;
import com.ericsson.em.m3if.financial.v1_0.common.IsApprovable;
import com.ericsson.em.m3if.financial.v1_0.common.TaxDetail;
import com.ericsson.em.m3if.financial.v1_0.common.UserApprovalStatus;
import com.ericsson.em.m3if.financial.v1_1.common.UserApprovalType;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.AccountDescriptionValue;
import com.ericsson.em.m3if.v1_0.common.ApprovalIdValue;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.FinancialTransactionId;
import com.ericsson.em.m3if.v1_0.common.FirstnameValue;
import com.ericsson.em.m3if.v1_0.common.IdentityValue;
import com.ericsson.em.m3if.v1_0.common.Iso8601DateTime;
import com.ericsson.em.m3if.v1_0.common.MessageValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.OfferIdentity;
import com.ericsson.em.m3if.v1_0.common.SurnameValue;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v2_5/common", name="userapprovaldetails", propOrder={"approvalId", "financialTransactionId", "approvalType", "approvalExpiryTime", "status", "amount", "fee", "discount", "offerIdentities", "initiatingAccountHolderId", "message", "accountFRI", "accountDescription", "taxDetails", "approvalsRequired", "transferType", "receivingFri", "receivingAccountholderFirstName", "receivingAccountholderLastName", "approvalCreationTime", "initiatingAccountholderFirstName", "initiatingAccountholderLastName", "approvable", "chargeDetails"})
public class UserApprovalDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Valid
    @NotNull
    @XmlElement(name="approvalid", type=ApprovalIdValue.class, required=true)
    private ApprovalIdValue approvalId;
    @Valid
    @XmlElement(name="financialtransactionid", type=FinancialTransactionId.class)
    private FinancialTransactionId financialTransactionId;
    @Valid
    @NotNull
    @XmlElement(name="approvaltype", type=UserApprovalType.class, required=true)
    private UserApprovalType approvalType;
    @Valid
    @NotNull
    @XmlElement(name="approvalexpirytime", type=Iso8601DateTime.class, required=true)
    private Iso8601DateTime approvalExpiryTime;
    @Valid
    @NotNull
    @XmlElement(name="status", type=UserApprovalStatus.class, required=true)
    private UserApprovalStatus status;
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="fee", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails fee;
    @Valid
    @XmlElement(name="discount", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails discount;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="offeridentities")
    @XmlElements(value={@XmlElement(name="offeridentity", type=OfferIdentity.class)})
    private List<OfferIdentity> offerIdentities;
    @Valid
    @XmlElement(name="initiatingaccountholderid", type=IdentityValue.class)
    private IdentityValue initiatingAccountHolderId;
    @Valid
    @XmlElement(name="message", type=MessageValue.class)
    private MessageValue message;
    @Valid
    @XmlElement(name="accountfri", type=FRIValue.class)
    private FRIValue accountFRI;
    @Valid
    @XmlElement(name="accountdescription", type=AccountDescriptionValue.class)
    private AccountDescriptionValue accountDescription;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="taxdetails")
    @XmlElements(value={@XmlElement(name="taxdetail", type=TaxDetail.class)})
    private List<TaxDetail> taxDetails;
    @Valid
    @XmlElement(name="approvalsrequired", type=ApprovalsRequired.class)
    private ApprovalsRequired approvalsRequired;
    @Valid
    @XmlElement(name="transfertype", type=TransferType.class)
    private TransferType transferType;
    @Valid
    @XmlElement(name="receivingfri", type=FRIValue.class)
    private FRIValue receivingFri;
    @Valid
    @XmlElement(name="receivingaccountholderfirstname", type=FirstnameValue.class)
    private FirstnameValue receivingAccountholderFirstName;
    @Valid
    @XmlElement(name="receivingaccountholderlastname", type=SurnameValue.class)
    private SurnameValue receivingAccountholderLastName;
    @Valid
    @XmlElement(name="approvalcreationtime", type=Iso8601DateTime.class)
    private Iso8601DateTime approvalCreationTime;
    @Valid
    @XmlElement(name="initiatingaccountholderfirstname", type=FirstnameValue.class)
    private FirstnameValue initiatingAccountholderFirstName;
    @Valid
    @XmlElement(name="initiatingaccountholderlastname", type=SurnameValue.class)
    private SurnameValue initiatingAccountholderLastName;
    @Valid
    @XmlElement(name="approvable", type=IsApprovable.class)
    private IsApprovable approvable;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="chargedetails")
    @XmlElements(value={@XmlElement(name="chargedetail", type=ChargeDetail.class)})
    private List<ChargeDetail> chargeDetails;

    public ApprovalIdValue getApprovalId() {
        return this.approvalId;
    }

    public void setApprovalId(ApprovalIdValue approvalId) {
        this.approvalId = approvalId;
    }

    public FinancialTransactionId getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(FinancialTransactionId financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public UserApprovalType getApprovalType() {
        return this.approvalType;
    }

    public void setApprovalType(UserApprovalType approvalType) {
        this.approvalType = approvalType;
    }

    public DateTime getApprovalExpiryTime() {
        return this.approvalExpiryTime.getValueAsDateTime();
    }

    public void setApprovalExpiryTime(DateTime approvalExpiryTime) {
        this.approvalExpiryTime = Iso8601DateTime.fromDateTime(approvalExpiryTime);
    }

    public UserApprovalStatus getStatus() {
        return this.status;
    }

    public void setStatus(UserApprovalStatus status) {
        this.status = status;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public IdentityValue getInitiatingAccountHolderId() {
        return this.initiatingAccountHolderId;
    }

    public void setInitiatingAccountHolderId(IdentityValue initiatingAccountHolderId) {
        this.initiatingAccountHolderId = initiatingAccountHolderId;
    }

    public MoneyDetails getFee() {
        return this.fee;
    }

    public void setFee(MoneyDetails fee) {
        this.fee = fee;
    }

    public MoneyDetails getDiscount() {
        return this.discount;
    }

    public void setDiscount(MoneyDetails discount) {
        this.discount = discount;
    }

    public List<OfferIdentity> getOfferIdentities() {
        return this.offerIdentities;
    }

    public void setOfferIdentities(List<OfferIdentity> offerIdentities) {
        this.offerIdentities = offerIdentities;
    }

    public void setOfferIdentitiesAsString(List<String> offerIdentities) {
        if (offerIdentities != null) {
            this.offerIdentities = new ArrayList<OfferIdentity>(offerIdentities.size());
            for (String id : offerIdentities) {
                this.offerIdentities.add(new OfferIdentity(id));
            }
        }
    }

    public MessageValue getMessage() {
        return this.message;
    }

    public void setMessage(MessageValue message) {
        this.message = message;
    }

    public FRIValue getAccountFRI() {
        return this.accountFRI;
    }

    public void setAccountFRI(FRIValue accountFRI) {
        this.accountFRI = accountFRI;
    }

    public AccountDescriptionValue getAccountDescription() {
        return this.accountDescription;
    }

    public void setAccountDescription(AccountDescriptionValue accountDescription) {
        this.accountDescription = accountDescription;
    }

    public List<TaxDetail> getTaxDetails() {
        return this.taxDetails;
    }

    public void setTaxDetails(List<TaxDetail> taxDetails) {
        this.taxDetails = taxDetails;
    }

    public ApprovalsRequired getApprovalsRequired() {
        return this.approvalsRequired;
    }

    public void setApprovalsRequired(ApprovalsRequired approvalsRequired) {
        this.approvalsRequired = approvalsRequired;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public FRIValue getReceivingFri() {
        return this.receivingFri;
    }

    public void setReceivingFri(FRIValue receivingFri) {
        this.receivingFri = receivingFri;
    }

    public FirstnameValue getReceivingAccountholderFirstName() {
        return this.receivingAccountholderFirstName;
    }

    public void setReceivingAccountholderFirstName(FirstnameValue receivingAccountholderFirstName) {
        this.receivingAccountholderFirstName = receivingAccountholderFirstName;
    }

    public SurnameValue getReceivingAccountholderLastName() {
        return this.receivingAccountholderLastName;
    }

    public void setReceivingAccountholderLastName(SurnameValue receivingAccountholderLastName) {
        this.receivingAccountholderLastName = receivingAccountholderLastName;
    }

    public Iso8601DateTime getApprovalCreationTime() {
        return this.approvalCreationTime;
    }

    public void setApprovalCreationTime(Iso8601DateTime approvalCreationTime) {
        this.approvalCreationTime = approvalCreationTime;
    }

    public FirstnameValue getInitiatingAccountholderFirstName() {
        return this.initiatingAccountholderFirstName;
    }

    public void setInitiatingAccountholderFirstName(FirstnameValue initiatingAccountholderFirstName) {
        this.initiatingAccountholderFirstName = initiatingAccountholderFirstName;
    }

    public SurnameValue getInitiatingAccountholderLastName() {
        return this.initiatingAccountholderLastName;
    }

    public void setInitiatingAccountholderLastName(SurnameValue initiatingAccountholderLastName) {
        this.initiatingAccountholderLastName = initiatingAccountholderLastName;
    }

    public IsApprovable getApprovable() {
        return this.approvable;
    }

    public void setApprovable(IsApprovable approvable) {
        this.approvable = approvable;
    }

    public List<ChargeDetail> getChargeDetails() {
        return this.chargeDetails;
    }

    public void setChargeDetails(List<ChargeDetail> chargeDetails) {
        this.chargeDetails = chargeDetails;
    }
}

