/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v2_2.transfer;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.ClientReferenceIdValue;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.FRIValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.m3if.v1_0.common.ReceiverMessageValue;
import com.ericsson.em.m3if.v1_0.common.RequestReferenceId;
import com.ericsson.em.m3if.v1_0.common.SenderNoteValue;
import com.ericsson.em.m3if.v1_2.common.ScheduledTransactionDate;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v2_2", name="transferrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v2_2", name="", propOrder={"sendingFRI", "receivingFRI", "amount", "senderNote", "receiverMessage", "referenceId", "scheduled", "extension", "quoteId", "requestReferenceId", "includeOffNet", "includeFee", "amountThreshold"})
public class TransferRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @Valid
    @XmlElement(name="sendingfri", type=FRIValue.class, required=false)
    private FRIValue sendingFRI;
    @Valid
    @NotNull
    @XmlElement(name="receivingfri", type=FRIValue.class, required=true)
    private FRIValue receivingFRI;
    @Valid
    @NotNull
    @IsPositiveAmount
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="sendernote", type=SenderNoteValue.class, required=false)
    private SenderNoteValue senderNote;
    @Valid
    @XmlElement(name="receivermessage", type=ReceiverMessageValue.class, required=false)
    private ReceiverMessageValue receiverMessage;
    @Valid
    @XmlElement(name="referenceid", type=ClientReferenceIdValue.class, required=false)
    private ClientReferenceIdValue referenceId;
    @Valid
    @XmlElement(name="scheduled", type=ScheduledTransactionDate.class, required=false)
    private ScheduledTransactionDate scheduled;
    @Valid
    @XmlElement(name="extension", type=ExtensionType.class, required=false)
    private ExtensionType extension;
    @Valid
    @XmlElement(name="quoteid", type=QuoteId.class, required=false)
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="requestreferenceid", type=RequestReferenceId.class, required=false)
    private RequestReferenceId requestReferenceId;
    @XmlElement(name="includeoffnet", defaultValue="false")
    private Boolean includeOffNet = false;
    @XmlElement(name="includefee", defaultValue="false")
    private Boolean includeFee = false;
    @XmlElement(name="amountthreshold", required=false)
    private Boolean amountThreshold;

    public TransferRequest() {
    }

    public TransferRequest(FRIValue sendingFRI, FRIValue receivingFRI, MoneyDetails amount) {
        this.setSendingFRI(sendingFRI);
        this.setReceivingFRI(receivingFRI);
        this.setAmount(amount);
    }

    public TransferRequest(FRIValue sendingFRI, FRIValue receivingFRI, MoneyDetails amount, String senderNote, String receiverMessage, String referenceId, ExtensionType extension) {
        this(sendingFRI, receivingFRI, amount);
        this.setSenderNote(SenderNoteValue.fromString(senderNote));
        this.setReceiverMessage(ReceiverMessageValue.fromString(receiverMessage));
        this.setReferenceId(ClientReferenceIdValue.fromString(referenceId));
        this.setExtension(extension);
    }

    public FRIValue getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(FRIValue sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public FRIValue getReceivingFRI() {
        return this.receivingFRI;
    }

    public void setReceivingFRI(FRIValue receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public SenderNoteValue getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(SenderNoteValue senderNote) {
        this.senderNote = senderNote;
    }

    public ReceiverMessageValue getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(ReceiverMessageValue receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public ClientReferenceIdValue getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(ClientReferenceIdValue referenceId) {
        this.referenceId = referenceId;
    }

    public ScheduledTransactionDate getScheduled() {
        return this.scheduled;
    }

    public void setScheduled(ScheduledTransactionDate scheduled) {
        this.scheduled = scheduled;
    }

    public ExtensionType getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public RequestReferenceId getRequestReferenceId() {
        return this.requestReferenceId;
    }

    public void setRequestReferenceId(RequestReferenceId requestReferenceId) {
        this.requestReferenceId = requestReferenceId;
    }

    public Boolean getIncludeOffNet() {
        return this.includeOffNet;
    }

    public void setIncludeOffNet(Boolean includeOffNet) {
        this.includeOffNet = includeOffNet;
    }

    public Boolean getIncludeFee() {
        return this.includeFee;
    }

    public void setIncludeFee(Boolean includeFee) {
        this.includeFee = includeFee;
    }

    public Boolean getAmountThreshold() {
        return this.amountThreshold;
    }

    public void setAmountThreshold(Boolean amountThreshold) {
        this.amountThreshold = amountThreshold;
    }
}

