/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_5.getaccounttransactionhistory;

import com.ericsson.em.m3if.operations.validation.IsDateTimeValue;
import com.ericsson.em.m3if.v1_0.common.CreditDebit;
import com.ericsson.em.m3if.v1_0.common.DateTimeValue;
import com.ericsson.em.m3if.v2_1.common.TransferType;
import com.ericsson.em.validators.IsExternalTransactionIdString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_5", name="getaccounttransactionhistoryrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_5", name="", propOrder={"accountFri", "counterAccountFri", "startDate", "endDate", "indexOffset", "numOfTransactions", "financialTransactionId", "externalTransactionId", "creditDebit", "transferType"})
public class GetAccountTransactionHistoryRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @IsFinancialResourceIdentifier
    @NotNull
    @XmlElement(name="accountfri", required=true)
    private String accountFri;
    @IsFinancialResourceIdentifier
    @XmlElement(name="counteraccountfri")
    private String counterAccountFri;
    @Valid
    @IsDateTimeValue
    @XmlElement(name="startdate")
    private DateTimeValue startDate;
    @Valid
    @IsDateTimeValue
    @XmlElement(name="enddate")
    private DateTimeValue endDate;
    @Min(value=0L)
    @NotNull
    @XmlElement(name="indexoffset", required=true)
    private @Min(value=0L) @NotNull Integer indexOffset;
    @Min(value=1L)
    @NotNull
    @XmlElement(name="numoftransactions", required=true)
    private @Min(value=1L) @NotNull Integer numOfTransactions;
    @IsPositiveLong(allowZero=false)
    @XmlElement(name="financialtransactionid")
    private Long financialTransactionId;
    @XmlElement(name="externaltransactionid")
    @IsExternalTransactionIdString
    private String externalTransactionId;
    @Valid
    @XmlElement(name="creditdebit")
    private CreditDebit creditDebit;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="transfertypes", nillable=true)
    @XmlElement(name="transfertype", nillable=false, type=TransferType.class)
    private List<TransferType> transferType = new LinkedList<TransferType>();

    public GetAccountTransactionHistoryRequest() {
    }

    public GetAccountTransactionHistoryRequest(String accountFri, Integer indexOffset, Integer numOfTransactions) {
        this.accountFri = accountFri;
        this.indexOffset = indexOffset;
        this.numOfTransactions = numOfTransactions;
    }

    public GetAccountTransactionHistoryRequest(String accountFri, String counterAccountFri, DateTimeValue startDate, DateTimeValue endDate, Integer indexOffset, Integer numOfTransactions, Long financialTransactionId, String externalTransactionId, CreditDebit creditDebit, List<TransferType> transferType) {
        this.accountFri = accountFri;
        this.counterAccountFri = counterAccountFri;
        this.startDate = startDate;
        this.endDate = endDate;
        this.indexOffset = indexOffset;
        this.numOfTransactions = numOfTransactions;
        this.financialTransactionId = financialTransactionId;
        this.externalTransactionId = externalTransactionId;
        this.creditDebit = creditDebit;
        this.transferType = transferType;
    }

    public GetAccountTransactionHistoryRequest(String accountFri, String counterAccountFriFri, DateTimeValue startDateFrom, DateTimeValue endDateFrom) {
        this.accountFri = accountFri;
        this.counterAccountFri = counterAccountFriFri;
        this.startDate = startDateFrom;
        this.endDate = endDateFrom;
    }

    public String getAccountFri() {
        return this.accountFri;
    }

    public void setAccountFri(String accountFri) {
        this.accountFri = accountFri;
    }

    public String getCounterAccountFri() {
        return this.counterAccountFri;
    }

    public void setCounterAccountFri(String counterAccountFri) {
        this.counterAccountFri = counterAccountFri;
    }

    public DateTimeValue getStartDate() {
        return this.startDate;
    }

    public void setStartDate(DateTimeValue startDate) {
        this.startDate = startDate;
    }

    public DateTimeValue getEndDate() {
        return this.endDate;
    }

    public void setEndDate(DateTimeValue endDate) {
        this.endDate = endDate;
    }

    public Integer getIndexOffset() {
        return this.indexOffset;
    }

    public void setIndexOffset(Integer indexOffset) {
        this.indexOffset = indexOffset;
    }

    public Integer getNumOfTransactions() {
        return this.numOfTransactions;
    }

    public void setNumOfTransactions(Integer numOfTransactions) {
        this.numOfTransactions = numOfTransactions;
    }

    public Long getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(Long financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    public String getExternalTransactionId() {
        return this.externalTransactionId;
    }

    public void setExternalTransactionId(String externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    public CreditDebit getCreditDebit() {
        return this.creditDebit;
    }

    public void setCreditDebit(CreditDebit creditDebit) {
        this.creditDebit = creditDebit;
    }

    public List<TransferType> getTransferType() {
        return this.transferType;
    }

    public void setTransferType(List<TransferType> transferType) {
        this.transferType = transferType;
    }
}

