/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_3.transfertobankaccount;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.approvals.ExpiredApprovalAware;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsIntegerWithinRange;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_3", name="transfertobankaccountrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_3", name="", propOrder={"sendingIdentity", "sendingFRI", "amount", "senderNote", "receiverMessage", "quoteId", "maxNumberOfRetries"})
public class TransferToBankAccountRequest
implements Serializable,
QuoteRequest,
ExpiredApprovalAware {
    private static final long serialVersionUID = 1L;
    @IsIdentity
    @XmlElement(name="sendingidentity")
    private String sendingIdentity;
    @NotNull
    @Valid
    @XmlElement(name="amount", required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @IsFinancialResourceIdentifier
    @XmlElement(name="sendingfri")
    private String sendingFRI;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="sendernote", required=false)
    private String senderNote;
    @Length(max=100)
    @IsRestrictedString
    @XmlElement(name="receivermessage", required=false)
    private String receiverMessage;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;
    @IsIntegerWithinRange(min=0)
    @XmlElement(name="maxnumberofretries", required=false)
    private Integer maxNumberOfRetries;

    public TransferToBankAccountRequest() {
    }

    public TransferToBankAccountRequest(String sendingIdentity, MoneyDetails amount) {
        this.sendingIdentity = sendingIdentity;
        this.amount = amount;
    }

    public String getSendingIdentity() {
        return this.sendingIdentity;
    }

    public void setSendingIdentity(String sendingIdentity) {
        this.sendingIdentity = sendingIdentity;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(String sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(String senderNote) {
        this.senderNote = senderNote;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public Integer getMaxNumberOfRetries() {
        return this.maxNumberOfRetries;
    }

    public void setMaxNumberOfRetries(Integer maxNumberOfRetries) {
        this.maxNumberOfRetries = maxNumberOfRetries;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    @Override
    public Optional<String> getSendingFri() {
        return Optional.ofNullable(this.sendingFRI);
    }

    @Override
    public Optional<String> getReceivingFri() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getSupplementaryData() {
        return Optional.ofNullable(this.sendingIdentity == null ? null : "Sending identity: " + this.sendingIdentity);
    }
}

