/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_1.common;

import com.ericsson.em.m3if.financial.v1_1.common.FinancialTransferApprovalType;
import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.OfferIdentity;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsSingleWordString;
import com.ericsson.em.validators.NoNullElements;
import com.ericsson.em.validators.NotEmpty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@Deprecated
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_1/common", name="userapprovaldetails", propOrder={"approvalId", "approvalType", "approvalExpiryTime", "status", "amount", "fee", "discount", "offerIdentities", "initiatingAccountHolderId"})
public class UserApprovalDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @XmlElement(name="approvalid", required=true)
    private Long approvalId;
    @XmlElement(name="approvaltype", required=true)
    private FinancialTransferApprovalType approvalType;
    @XmlElement(name="approvalexpirytime", required=true)
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date approvalExpiryTime;
    @IsSingleWordString
    @XmlElement(name="status", required=true)
    private String status;
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class, required=false)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Valid
    @XmlElement(name="fee", type=MoneyDetails.class, required=false)
    @IsPositiveAmount
    private MoneyDetails fee;
    @Valid
    @XmlElement(name="discount", type=MoneyDetails.class, required=false)
    @IsPositiveAmount
    private MoneyDetails discount;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="offeridentities")
    @XmlElements(value={@XmlElement(name="offeridentity", required=false, type=OfferIdentity.class)})
    private List<OfferIdentity> offerIdentities;
    @NotEmpty
    @IsIdentity
    @XmlElement(name="initiatingaccountholderid", required=false)
    private String initiatingAccountHolderId;

    public Long getApprovalId() {
        return this.approvalId;
    }

    public void setApprovalId(Long approvalId) {
        this.approvalId = approvalId;
    }

    public FinancialTransferApprovalType getApprovalType() {
        return this.approvalType;
    }

    public void setApprovalType(FinancialTransferApprovalType approvalType) {
        this.approvalType = approvalType;
    }

    public DateTime getApprovalExpiryTime() {
        return DateHelper.fromDate(this.approvalExpiryTime);
    }

    public void setApprovalExpiryTime(DateTime approvalExpiryTime) {
        this.approvalExpiryTime = DateHelper.toDate(approvalExpiryTime);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getInitiatingAccountHolderId() {
        return this.initiatingAccountHolderId;
    }

    public void setInitiatingAccountHolderId(String initiatingAccountHolderId) {
        this.initiatingAccountHolderId = initiatingAccountHolderId;
    }

    public MoneyDetails getFee() {
        return this.fee;
    }

    public void setFee(MoneyDetails fee) {
        this.fee = fee;
    }

    public MoneyDetails getDiscount() {
        return this.discount;
    }

    public void setDiscount(MoneyDetails discount) {
        this.discount = discount;
    }

    public List<OfferIdentity> getOfferIdentities() {
        return this.offerIdentities;
    }

    public void setOfferIdentities(List<OfferIdentity> offerIdentities) {
        this.offerIdentities = offerIdentities;
    }

    public void setOfferIdentitiesAsString(List<String> offerIdentities) {
        if (offerIdentities != null) {
            this.offerIdentities = new ArrayList<OfferIdentity>(offerIdentities.size());
            for (String id : offerIdentities) {
                this.offerIdentities.add(new OfferIdentity(id));
            }
        }
    }
}

