/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.refund;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.ClientReferenceIdValue;
import com.ericsson.em.m3if.v1_0.common.ExternalTransactionIdValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.validators.IsPositiveLong;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="refundrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="", propOrder={"amount", "refunderNote", "receiverMessage", "financialTransactionId", "quoteId", "clientReferenceId", "externalTransactionId"})
public class RefundRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @NotNull
    @Valid
    @XmlElement(name="amount", required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="refundernote")
    private String refunderNote;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="receivermessage")
    private String receiverMessage;
    @IsPositiveLong(allowNull=false, allowZero=false)
    @XmlElement(name="financialtransactionid", required=true)
    private Long financialTransactionId;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="clientreferenceid", type=ClientReferenceIdValue.class)
    private ClientReferenceIdValue clientReferenceId;
    @Valid
    @XmlElement(name="externaltransactionid", type=ExternalTransactionIdValue.class)
    private ExternalTransactionIdValue externalTransactionId;

    public RefundRequest() {
    }

    public RefundRequest(MoneyDetails amount) {
        this(amount, null, null, null);
    }

    public RefundRequest(MoneyDetails amount, String senderNote, String receiverMessage, Long financialTransactionId) {
        this.amount = amount;
        this.refunderNote = senderNote;
        this.receiverMessage = receiverMessage;
        this.financialTransactionId = financialTransactionId;
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public String getRefunderNote() {
        return this.refunderNote;
    }

    public void setRefunderNote(String refunderNote) {
        this.refunderNote = refunderNote;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public Long getFinancialTransactionId() {
        return this.financialTransactionId;
    }

    public void setFinancialTransactionId(Long financialTransactionId) {
        this.financialTransactionId = financialTransactionId;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public Optional<ClientReferenceIdValue> getClientReferenceId() {
        return Optional.ofNullable(this.clientReferenceId);
    }

    public void setClientReferenceId(ClientReferenceIdValue referenceId) {
        this.clientReferenceId = referenceId;
    }

    public Optional<ExternalTransactionIdValue> getExternalTransactionId() {
        return Optional.ofNullable(this.externalTransactionId);
    }

    public void setExternalTransactionId(ExternalTransactionIdValue externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }
}

