/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.floattransfer;

import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.v1_0.common.ExtensionType;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.validators.IsAmount;
import com.ericsson.em.validators.IsExternalReferenceString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@Deprecated
@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="floattransferrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="", propOrder={"sendingFRI", "receivingIdentity", "amount", "senderNote", "receiverMessage", "referenceId", "extension", "quoteId"})
public class FloatTransferRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @IsFinancialResourceIdentifier
    @XmlElement(name="sendingfri")
    private String sendingFRI;
    @NotNull
    @IsIdentity
    @XmlElement(name="receivingidentity", required=true)
    private String receivingIdentity;
    @NotNull
    @IsAmount
    @XmlElement(name="amount", required=true)
    private BigDecimal amount;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="sendernote")
    private String senderNote;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="receivermessage")
    private String receiverMessage;
    @Length(min=1, max=64)
    @IsExternalReferenceString
    @XmlElement(name="referenceid")
    private String referenceId;
    @Valid
    @XmlElement(name="extension")
    private ExtensionType extension;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;

    public FloatTransferRequest() {
    }

    public FloatTransferRequest(String sendingFRI, String receivingIdentity, BigDecimal amount) {
        this.setSendingFRI(sendingFRI);
        this.setReceivingIdentity(receivingIdentity);
        this.setAmount(amount);
    }

    public FloatTransferRequest(String sendingFRI, String receivingIdentity, BigDecimal amount, String senderNote, String receiverMessage, String referenceId, ExtensionType extension) {
        this(sendingFRI, receivingIdentity, amount);
        this.setSenderNote(senderNote);
        this.setReceiverMessage(receiverMessage);
        this.setReferenceId(referenceId);
        this.setExtension(extension);
    }

    public String getSendingFRI() {
        return this.sendingFRI;
    }

    public void setSendingFRI(String sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    public String getReceivingIdentity() {
        return this.receivingIdentity;
    }

    public void setReceivingIdentity(String receivingIdentity) {
        this.receivingIdentity = receivingIdentity;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public void setSenderNote(String senderNote) {
        this.senderNote = senderNote;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public ExtensionType getExtension() {
        return this.extension;
    }

    public void setExtension(ExtensionType extension) {
        this.extension = extension;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }
}

