/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.common;

import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0/common", name="customoperation")
@XmlEnum
public enum CustomOperation {
    TRANSFEROWNACCOUNT("ROLE_CUSTOM_TRANSFER_FROM_OWN_ACCOUNT_WITH_CUSTOM_TRANSFER_TYPE"),
    TRANSFERANYACCOUNT("ROLE_CUSTOM_TRANSFER_FROM_ANY_ACCOUNT_WITH_CUSTOM_TRANSFER_TYPE"),
    DEBIT("ROLE_DEBIT_WITH_CUSTOM_TRANSFER_TYPE"),
    PAYMENT("ROLE_PAYMENT_WITH_CUSTOM_TRANSFER_TYPE");

    @XmlValue
    @NotNull
    private String customOperationPermission;

    private CustomOperation(String customOperationPermission) {
        this.customOperationPermission = customOperationPermission;
    }

    public String getCustomOperationPermission() {
        return this.customOperationPermission;
    }

    public static String get(String customOperationPermission) {
        return Arrays.stream(CustomOperation.values()).filter(co -> co.customOperationPermission.equals(customOperationPermission)).findFirst().map(Enum::name).orElseThrow(() -> new IllegalArgumentException("No custom operation exists for permission " + customOperationPermission));
    }
}

