/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.financial.v1_0.cashtransfer;

import com.ericsson.em.m3if.financial.v1_0.common.AdditionalTransactionDetails;
import com.ericsson.em.m3if.financial.v1_0.quotation.QuoteRequest;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.CashUserInformation;
import com.ericsson.em.m3if.v1_0.common.ExternalTransactionIdValue;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.QuoteId;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="cashtransferrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/financial/v1_0", name="", propOrder={"sendingFRI", "receivingFRI", "amount", "senderNote", "receiverMessage", "cashUser", "externalTransactionId", "additionalTransactionDetails", "quoteId"})
public class CashTransferRequest
implements Serializable,
QuoteRequest {
    private static final long serialVersionUID = 1L;
    @IsFinancialResourceIdentifier
    @XmlElement(name="sendingfri")
    private String sendingFRI;
    @NotNull
    @IsFinancialResourceIdentifier
    @XmlElement(name="receivingfri", required=true)
    private String receivingFRI;
    @NotNull
    @Valid
    @XmlElement(name="amount", type=MoneyDetails.class, required=true)
    @IsPositiveAmount
    private MoneyDetails amount;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="sendernote")
    private String senderNote;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="receivermessage")
    private String receiverMessage;
    @NotNull
    @Valid
    @XmlElement(name="cashuser", required=true)
    private CashUserInformation cashUser;
    @Valid
    @XmlElement(name="quoteid")
    private QuoteId quoteId;
    @Valid
    @XmlElement(name="externaltransactionid")
    private ExternalTransactionIdValue externalTransactionId;
    @Valid
    @XmlElement(name="additionaltransactiondetails")
    private AdditionalTransactionDetails additionalTransactionDetails;

    public CashTransferRequest() {
    }

    public CashTransferRequest(CashUserInformation cashUser, String sendingFRI, String receivingFRI, MoneyDetails amount, String senderNote, String receiverMessage) {
        this.setCashUser(cashUser);
        this.setSendingFRI(sendingFRI);
        this.setReceivingFRI(receivingFRI);
        this.setAmount(amount);
        this.setSenderNote(senderNote);
        this.setReceiverMessage(receiverMessage);
    }

    public MoneyDetails getAmount() {
        return this.amount;
    }

    public CashUserInformation getCashUser() {
        return this.cashUser;
    }

    public String getReceiverMessage() {
        return this.receiverMessage;
    }

    public String getReceivingFRI() {
        return this.receivingFRI;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public String getSendingFRI() {
        return this.sendingFRI;
    }

    public void setAmount(MoneyDetails amount) {
        this.amount = amount;
    }

    public void setCashUser(CashUserInformation cashUser) {
        this.cashUser = cashUser;
    }

    public void setReceiverMessage(String receiverMessage) {
        this.receiverMessage = receiverMessage;
    }

    public void setReceivingFRI(String receivingFRI) {
        this.receivingFRI = receivingFRI;
    }

    public void setSenderNote(String senderNote) {
        this.senderNote = senderNote;
    }

    public void setSendingFRI(String sendingFRI) {
        this.sendingFRI = sendingFRI;
    }

    @Override
    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    @Override
    public void setQuoteId(QuoteId quoteId) {
        this.quoteId = quoteId;
    }

    public void setExternalTransactionId(ExternalTransactionIdValue externalTransactionId) {
        this.externalTransactionId = externalTransactionId;
    }

    public ExternalTransactionIdValue getExternalTransactionId() {
        return this.externalTransactionId;
    }

    public AdditionalTransactionDetails getAdditionalTransactionDetails() {
        return this.additionalTransactionDetails;
    }

    public void setAdditionalTransactionDetails(AdditionalTransactionDetails additionalTransactionDetails) {
        this.additionalTransactionDetails = additionalTransactionDetails;
    }
}

