/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.coupons.v1_0.createoffer;

import com.ericsson.em.m3if.coupons.v1_0.common.Awarder;
import com.ericsson.em.m3if.coupons.v1_0.common.Reward;
import com.ericsson.em.m3if.coupons.v1_0.common.RewardType;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.m3if.v1_0.common.ProfileName;
import com.ericsson.em.validators.IsDateString;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import com.ericsson.em.validators.NotBlank;
import com.ericsson.em.validators.NotEmpty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;

@XmlRootElement(name="createofferrequest", namespace="http://www.ericsson.com/em/emm/coupons/v1_0")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", namespace="http://www.ericsson.com/em/emm/coupons/v1_0", propOrder={"fundingAccountFRI", "offerStartDate", "offerEndDate", "couponsValidityDays", "offerDescription", "totalCoupons", "couponsPerUser", "awarders", "userProfiles", "minimumPurchaseAmount", "maximumPurchaseAmount", "reward", "rewardType", "totalAmountRedeemable", "identityListUploaded"})
public class CreateOfferRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    public static final String version = "1.0";
    @IsFinancialResourceIdentifier
    @XmlElement(name="fundingaccountfri")
    private String fundingAccountFRI;
    @NotNull
    @NotBlank
    @IsDateString(format=IsDateString.DATE_FORMAT.ISO)
    @XmlElement(name="offerstartdate", required=true)
    private String offerStartDate;
    @NotNull
    @NotBlank
    @IsDateString(format=IsDateString.DATE_FORMAT.ISO)
    @XmlElement(name="offerenddate", required=true)
    private String offerEndDate;
    @Min(value=0L)
    @XmlElement(name="couponsvaliditydays")
    private @Min(value=0L) Integer couponsValidityDays;
    @Length(max=256)
    @IsRestrictedString
    @XmlElement(name="offerdescription")
    private String offerDescription;
    @NotNull
    @Min(value=1L)
    @XmlElement(name="totalcoupons", required=true)
    private @NotNull @Min(value=1L) Long totalCoupons;
    @NotNull
    @Min(value=1L)
    @XmlElement(name="couponsperuser", required=true)
    private @NotNull @Min(value=1L) Integer couponsPerUser;
    @Valid
    @NotEmpty
    @NoNullElements
    @XmlElementWrapper(name="awarders", required=true)
    @XmlElements(value={@XmlElement(name="awarder", type=Awarder.class, required=true)})
    private List<Awarder> awarders = new ArrayList<Awarder>();
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="userprofiles")
    @XmlElements(value={@XmlElement(name="userprofile", type=ProfileName.class)})
    private List<ProfileName> userProfiles;
    @Valid
    @XmlElement(name="minimumpurchaseamount", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails minimumPurchaseAmount;
    @Valid
    @XmlElement(name="maximumpurchaseamount", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails maximumPurchaseAmount;
    @Valid
    @NotNull
    @XmlElement(name="reward", required=true, type=Reward.class)
    private Reward reward;
    @NotNull
    @XmlElement(name="rewardtype", required=true)
    private RewardType rewardType;
    @Valid
    @XmlElement(name="totalamountredeemable", type=MoneyDetails.class)
    @IsPositiveAmount
    private MoneyDetails totalAmountRedeemable;
    @XmlElement(name="identitylistuploaded", defaultValue="false")
    private Boolean identityListUploaded = false;

    public String getFundingAccountFRI() {
        return this.fundingAccountFRI;
    }

    public void setFundingAccountFRI(String fundingAccountFRI) {
        this.fundingAccountFRI = fundingAccountFRI;
    }

    public DateTime getOfferStartDate() {
        return this.offerStartDate == null ? null : DateTime.parse(this.offerStartDate, DateTimeFormat.forPattern("yyyy-MM-dd")).withTime(0, 0, 0, 0);
    }

    public void setOfferStartDate(DateTime startDate) {
        this.offerStartDate = startDate == null ? null : startDate.toString("yyyy-MM-dd");
    }

    public DateTime getOfferEndDate() {
        return this.offerEndDate == null ? null : DateTime.parse(this.offerEndDate, DateTimeFormat.forPattern("yyyy-MM-dd")).withTime(23, 59, 59, 999);
    }

    public void setOfferEndDate(DateTime endDate) {
        this.offerEndDate = endDate == null ? null : endDate.toString("yyyy-MM-dd");
    }

    public Integer getCouponsValidityDays() {
        return this.couponsValidityDays;
    }

    public void setCouponsValidityDays(Integer couponsValidityDays) {
        this.couponsValidityDays = couponsValidityDays;
    }

    public String getOfferDescription() {
        return this.offerDescription;
    }

    public void setOfferDescription(String offerDescription) {
        this.offerDescription = offerDescription;
    }

    public Long getTotalCoupons() {
        return this.totalCoupons;
    }

    public void setTotalCoupons(Long totalCoupons) {
        this.totalCoupons = totalCoupons;
    }

    public Integer getCouponsPerUser() {
        return this.couponsPerUser;
    }

    public void setCouponsPerUser(Integer couponsPerUser) {
        this.couponsPerUser = couponsPerUser;
    }

    public List<Awarder> getAwarders() {
        return this.awarders;
    }

    public void setAwarders(List<Awarder> awarders) {
        this.awarders = awarders;
    }

    public List<ProfileName> getUserProfiles() {
        return this.userProfiles;
    }

    public void setUserProfiles(List<ProfileName> userProfiles) {
        this.userProfiles = userProfiles;
    }

    public MoneyDetails getMinimumPurchaseAmount() {
        return this.minimumPurchaseAmount;
    }

    public void setMinimumPurchaseAmount(MoneyDetails minimumPurchaseAmount) {
        this.minimumPurchaseAmount = minimumPurchaseAmount;
    }

    public MoneyDetails getMaximumPurchaseAmount() {
        return this.maximumPurchaseAmount;
    }

    public void setMaximumPurchaseAmount(MoneyDetails maximumPurchaseAmount) {
        this.maximumPurchaseAmount = maximumPurchaseAmount;
    }

    public Reward getReward() {
        return this.reward;
    }

    public void setReward(Reward reward) {
        this.reward = reward;
    }

    public RewardType getRewardType() {
        return this.rewardType;
    }

    public void setRewardType(RewardType rewardType) {
        this.rewardType = rewardType;
    }

    public MoneyDetails getTotalAmountRedeemable() {
        return this.totalAmountRedeemable;
    }

    public void setTotalAmountRedeemable(MoneyDetails totalAmountRedeemable) {
        this.totalAmountRedeemable = totalAmountRedeemable;
    }

    public Boolean getIdentityListUploaded() {
        return this.identityListUploaded;
    }

    public void setIdentityListUploaded(Boolean identityListUploaded) {
        this.identityListUploaded = identityListUploaded;
    }
}

