/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.batchtransfer.v1_0.listbatchtransfer;

import com.ericsson.em.m3if.batchtransfer.v1_0.common.BatchTransferStatus;
import com.ericsson.em.m3if.operations.utils.DateHelper;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.joda.time.DateTime;

@XmlRootElement(namespace="http://www.ericsson.com/em/emm/batchtransfer/v1_0", name="listbatchtransferrequest")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/batchtransfer/v1_0", name="", propOrder={"fromAccountFri", "numberOfBatches", "startDate", "endDate", "statusList"})
public class ListBatchTransferRequest
implements Serializable {
    private static final long serialVersionUID = 5621534484511061189L;
    @XmlAttribute
    public static final String version = "1.0";
    @XmlElement(name="fromaccountfri")
    @IsFinancialResourceIdentifier
    private String fromAccountFri;
    @XmlElement(name="numberofbatches")
    private Integer numberOfBatches;
    @XmlElement(name="startdate")
    private Date startDate;
    @XmlElement(name="enddate")
    private Date endDate;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="statuslist")
    @XmlElement(name="status", type=BatchTransferStatus.class)
    private List<BatchTransferStatus> statusList;

    public ListBatchTransferRequest() {
    }

    public ListBatchTransferRequest(DateTime startDate, DateTime endDate) {
        this.startDate = DateHelper.toDate(startDate);
        this.endDate = DateHelper.toDate(endDate);
    }

    public ListBatchTransferRequest(String fromAccountFri, DateTime startDate, DateTime endDate) {
        this.fromAccountFri = fromAccountFri;
        this.startDate = DateHelper.toDate(startDate);
        this.endDate = DateHelper.toDate(endDate);
    }

    public ListBatchTransferRequest(DateTime startDate, DateTime endDate, Integer numberOfBatches) {
        this.startDate = DateHelper.toDate(startDate);
        this.endDate = DateHelper.toDate(endDate);
        this.numberOfBatches = numberOfBatches;
    }

    public String getFromAccountFri() {
        return this.fromAccountFri;
    }

    public void setFromAccountFri(String fromAccountFri) {
        this.fromAccountFri = fromAccountFri;
    }

    public DateTime getStartDate() {
        return DateHelper.fromDate(this.startDate);
    }

    public void setStartDate(DateTime startDate) {
        this.startDate = DateHelper.toDate(startDate);
    }

    public DateTime getEndDate() {
        return DateHelper.fromDate(this.endDate);
    }

    public void setEndDate(DateTime endDate) {
        this.endDate = DateHelper.toDate(endDate);
    }

    public Integer getNumberOfBatches() {
        return this.numberOfBatches;
    }

    public void setNumberOfBatches(Integer numberOfBatches) {
        this.numberOfBatches = numberOfBatches;
    }

    public List<BatchTransferStatus> getStatusList() {
        return this.statusList;
    }

    public void setStatusList(List<BatchTransferStatus> statusList) {
        this.statusList = statusList;
    }
}

