/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.m3if.batchtransfer.v1_0.common;

import com.ericsson.em.m3if.batchtransfer.v1_0.common.BatchTransferStatus;
import com.ericsson.em.m3if.batchtransfer.v1_0.common.ReversalBatchInfo;
import com.ericsson.em.m3if.batchtransfer.v1_0.common.TransactionDate;
import com.ericsson.em.m3if.batchtransfer.v1_0.common.TransactionRecord;
import com.ericsson.em.m3if.operations.adapter.DateAdapter;
import com.ericsson.em.m3if.operations.validation.IsPositiveAmount;
import com.ericsson.em.m3if.v1_0.common.MoneyDetails;
import com.ericsson.em.validators.IsFinancialResourceIdentifier;
import com.ericsson.em.validators.IsIdentity;
import com.ericsson.em.validators.IsMultiWordString;
import com.ericsson.em.validators.IsUsername;
import com.ericsson.em.validators.NoNullElements;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(namespace="http://www.ericsson.com/em/emm/batchtransfer/v1_0/common", name="batchinfotype", propOrder={"batchId", "title", "receiveTimeStamp", "completedTimeStamp", "fromAccountFri", "batchCreator", "batchCreatorName", "batchApprover", "batchApproverName", "batchApprovable", "batchCancelledBy", "batchCancelledByName", "numberOfRecords", "totalAmount", "status", "numberOfSuccess", "numberOfFailure", "totalFee", "totalTransferedAmount", "transactionRecords", "scheduleDate", "reversalBatchInfo"})
public class BatchInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="batchid", required=true)
    private Long batchId;
    @IsMultiWordString
    @XmlElement(name="title")
    private String title;
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @XmlElement(name="receivetimestamp", required=true)
    private Date receiveTimeStamp;
    @XmlSchemaType(name="dateTime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @XmlElement(name="completedtimestamp")
    private Date completedTimeStamp;
    @IsFinancialResourceIdentifier
    @XmlElement(name="fromaccountfri", required=true)
    private String fromAccountFri;
    @IsIdentity
    @XmlElement(name="batchcreator", required=true)
    private String batchCreator;
    @IsUsername
    @XmlElement(name="batchcreatorname")
    private String batchCreatorName;
    @IsIdentity
    @XmlElement(name="batchapprover")
    private String batchApprover;
    @IsUsername
    @XmlElement(name="batchapprovername")
    private String batchApproverName;
    @XmlElement(name="batchapprovable")
    private Boolean batchApprovable;
    @IsIdentity
    @XmlElement(name="batchcancelledby")
    private String batchCancelledBy;
    @IsUsername
    @XmlElement(name="batchcancelledbyname")
    private String batchCancelledByName;
    @XmlElement(name="numberofrecords", required=true)
    private Long numberOfRecords;
    @Valid
    @NotNull
    @XmlElement(name="totalamount", required=true)
    @IsPositiveAmount
    private MoneyDetails totalAmount;
    @XmlElement(name="status", required=true)
    private BatchTransferStatus status;
    @XmlElement(name="numberofsuccess")
    private Long numberOfSuccess;
    @XmlElement(name="numberoffailure")
    private Long numberOfFailure;
    @Valid
    @XmlElement(name="totalfee")
    @IsPositiveAmount
    private MoneyDetails totalFee;
    @Valid
    @XmlElement(name="totaltransferedamount")
    @IsPositiveAmount
    private MoneyDetails totalTransferedAmount;
    @Valid
    @NoNullElements
    @XmlElementWrapper(name="transactionrecords")
    @XmlElements(value={@XmlElement(name="transactionrecord", type=TransactionRecord.class)})
    private List<TransactionRecord> transactionRecords;
    @Valid
    @XmlElement(name="scheduledate", type=TransactionDate.class)
    private TransactionDate scheduleDate;
    @XmlElement(name="reversalbatchinfo")
    @Valid
    private ReversalBatchInfo reversalBatchInfo;

    public BatchInfo() {
    }

    public BatchInfo(Long batchId, String title, DateTime receiveTimeStamp, Long numberOfRecords, MoneyDetails totalAmount, BatchTransferStatus status, Long numberOfSuccess, Long numberOfFailure, MoneyDetails totalFee, MoneyDetails totalTransferedAmount, List<TransactionRecord> transactionRecords, TransactionDate scheduleDate) {
        this.batchId = batchId;
        this.title = title;
        this.receiveTimeStamp = receiveTimeStamp.toDate();
        this.numberOfRecords = numberOfRecords;
        this.totalAmount = totalAmount;
        this.status = status;
        this.numberOfSuccess = numberOfSuccess;
        this.numberOfFailure = numberOfFailure;
        this.totalFee = totalFee;
        this.totalTransferedAmount = totalTransferedAmount;
        this.transactionRecords = transactionRecords;
        this.scheduleDate = scheduleDate;
    }

    public Long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(Long batchId) {
        this.batchId = batchId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DateTime getReceiveTimeStamp() {
        return this.receiveTimeStamp == null ? null : new DateTime(this.receiveTimeStamp);
    }

    public void setReceiveTimeStamp(DateTime receiveTimeStamp) {
        this.receiveTimeStamp = receiveTimeStamp == null ? null : receiveTimeStamp.toDate();
    }

    public void setCompletedTimeStamp(DateTime completedTimeStamp) {
        this.completedTimeStamp = completedTimeStamp == null ? null : completedTimeStamp.toDate();
    }

    public DateTime getCompletedTimeStamp() {
        return this.completedTimeStamp == null ? null : new DateTime(this.completedTimeStamp);
    }

    public void setFromAccountFri(String fromAccountFri) {
        this.fromAccountFri = fromAccountFri;
    }

    public String getFromAccountFri() {
        return this.fromAccountFri;
    }

    public void setBatchCreator(String batchCreator) {
        this.batchCreator = batchCreator;
    }

    public String getBatchCreator() {
        return this.batchCreator;
    }

    public void setBatchCreatorName(String batchCreatorName) {
        this.batchCreatorName = batchCreatorName;
    }

    public String getBatchCreatorName() {
        return this.batchCreatorName;
    }

    public void setBatchApprover(String batchApprover) {
        this.batchApprover = batchApprover;
    }

    public String getBatchApprover() {
        return this.batchApprover;
    }

    public void setBatchApproverName(String batchApproverName) {
        this.batchApproverName = batchApproverName;
    }

    public String getBatchApproverName() {
        return this.batchApproverName;
    }

    public Boolean getBatchApprovable() {
        return this.batchApprovable;
    }

    public void setBatchApprovable(Boolean batchApprovable) {
        this.batchApprovable = batchApprovable;
    }

    public void setBatchCancelledBy(String batchCancelledBy) {
        this.batchCancelledBy = batchCancelledBy;
    }

    public String getBatchCancelledBy() {
        return this.batchCancelledBy;
    }

    public void setBatchCancelledByName(String batchCancelledByName) {
        this.batchCancelledByName = batchCancelledByName;
    }

    public String getBatchCancelledByName() {
        return this.batchCancelledByName;
    }

    public Long getNumberOfRecords() {
        return this.numberOfRecords;
    }

    public void setNumberOfRecords(Long numberOfRecords) {
        this.numberOfRecords = numberOfRecords;
    }

    public MoneyDetails getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(MoneyDetails totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BatchTransferStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatchTransferStatus status) {
        this.status = status;
    }

    public Long getNumberOfSuccess() {
        return this.numberOfSuccess;
    }

    public void setNumberOfSuccess(Long numberOfSuccess) {
        this.numberOfSuccess = numberOfSuccess;
    }

    public Long getNumberOfFailure() {
        return this.numberOfFailure;
    }

    public void setNumberOfFailure(Long numberOfFailure) {
        this.numberOfFailure = numberOfFailure;
    }

    public MoneyDetails getTotalFee() {
        return this.totalFee;
    }

    public void setTotalFee(MoneyDetails totalFee) {
        this.totalFee = totalFee;
    }

    public MoneyDetails getTotalTransferedAmount() {
        return this.totalTransferedAmount;
    }

    public void setTotalTransferedAmount(MoneyDetails totalTransferedAmount) {
        this.totalTransferedAmount = totalTransferedAmount;
    }

    public List<TransactionRecord> getTransactionRecords() {
        return this.transactionRecords;
    }

    public void setTransactionRecords(List<TransactionRecord> transactionRecords) {
        this.transactionRecords = transactionRecords;
    }

    public TransactionDate getScheduleDate() {
        return this.scheduleDate;
    }

    public void setScheduleDate(TransactionDate scheduleDate) {
        this.scheduleDate = scheduleDate;
    }

    public ReversalBatchInfo getReversalBatchInfo() {
        return this.reversalBatchInfo;
    }

    public void setReversalBatchInfo(ReversalBatchInfo reversalBatchInfo) {
        this.reversalBatchInfo = reversalBatchInfo;
    }
}

