/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.web.ere.rma;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWatcher
implements Runnable {
    private WatchService watchService;
    private static final Logger LOGGER = LoggerFactory.getLogger("FileWatchService");
    private final Runnable onUpdate;
    private final Path file;
    private boolean isKubernetesMountedFile;

    public FileWatcher(Path file, Runnable onUpdate) throws IOException {
        this.file = file;
        this.onUpdate = onUpdate;
        this.checkIfIsKubernetesMountedFile();
        this.startWatchingFile(file);
    }

    @Override
    public void run() {
        WatchKey key;
        while ((key = this.take()) != null) {
            List fileEvents = this.isKubernetesMountedFile ? key.pollEvents().stream().filter(event -> "..data".equals(event.context().toString())).collect(Collectors.toList()) : key.pollEvents().stream().filter(event -> "srvcert.pem".equals(event.context().toString())).collect(Collectors.toList());
            if (!fileEvents.isEmpty() && this.file.resolve("srvcert.pem").toFile().exists() && this.file.resolve("srvprivkey.pem").toFile().exists()) {
                this.onUpdate.run();
            }
            key.reset();
        }
    }

    private void startWatchingFile(Path file) throws IOException {
        this.watchService = FileSystems.getDefault().newWatchService();
        file.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
    }

    private void checkIfIsKubernetesMountedFile() {
        Path certFile = this.file.resolve("srvcert.pem");
        try {
            this.isKubernetesMountedFile = Files.isSymbolicLink(certFile) && Files.readSymbolicLink(certFile).getParent().endsWith("..data");
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read symbolic link", (Object)e.getMessage());
            this.isKubernetesMountedFile = false;
        }
    }

    private WatchKey take() {
        WatchKey key = null;
        try {
            key = this.watchService.take();
        }
        catch (InterruptedException e) {
            LOGGER.warn("File watch interrupted for file {}", (Object)this.file.toString());
        }
        return key;
    }
}

