/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emm.ere.rma.connector;

import com.ericsson.ere.swing.EDT;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.AbstractDialog;
import ericsson.ere.gui.util.DialogFactory;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public final class CredentialChangeDialog
extends AbstractDialog {
    private JButton mCancelButton;
    private JButton mOKButton;
    private JPanel mButtonPanel;
    private JPanel mMainPanel;
    private JPasswordField mPasswordField;
    private JPasswordField mConfirmPasswordField;
    private boolean mIsAccepted = false;
    private String mPassword;

    private CredentialChangeDialog() {
        super((Frame)GuiServiceCenter.getInstance().getMainWindow(), true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.mOKButton);
        this.mPasswordField.setText("");
        this.mConfirmPasswordField.setText("");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                JPasswordField focusedComponent = CredentialChangeDialog.this.mPasswordField;
                if (!CredentialChangeDialog.this.requestFocusInWindow()) {
                    CredentialChangeDialog.this.requestFocus();
                }
                ((Component)focusedComponent).requestFocusInWindow();
            }
        });
        this.center();
    }

    private void initComponents() {
        JLabel passwordLabel = new JLabel();
        JLabel confirmPasswordLabel = new JLabel();
        this.mMainPanel = new JPanel();
        this.mPasswordField = new JPasswordField();
        this.mConfirmPasswordField = new JPasswordField();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.setName("CredentialChangeDialog");
        this.mPasswordField.setName("CredentialChangeDialog.Password");
        this.mConfirmPasswordField.setName("CredentialChangeDialog.ConfirmPassword");
        this.mOKButton.setName("CredentialChangeDialog.OkButton");
        this.mCancelButton.setName("CredentialChangeDialog.CancelButton");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CredentialChangeDialog.this.closeDialog();
            }
        });
        this.mMainPanel.setLayout(new GridBagLayout());
        this.mMainPanel.setBorder(new TitledBorder(new EtchedBorder(), "Enter Password"));
        passwordLabel.setFont(new Font("Dialog", 0, 12));
        passwordLabel.setText("Password:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mMainPanel.add((Component)passwordLabel, gridBagConstraints);
        this.mPasswordField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        this.mMainPanel.add((Component)this.mPasswordField, gridBagConstraints);
        confirmPasswordLabel.setFont(new Font("Dialog", 0, 12));
        confirmPasswordLabel.setText("Confirm Password:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mMainPanel.add((Component)confirmPasswordLabel, gridBagConstraints);
        this.mConfirmPasswordField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        this.mMainPanel.add((Component)this.mConfirmPasswordField, gridBagConstraints);
        this.mOKButton.setText("OK");
        this.mOKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CredentialChangeDialog.this.btnOKActionPerformed();
            }
        });
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setText("Cancel");
        this.mCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CredentialChangeDialog.this.performCancel();
            }
        });
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.mMainPanel.add((Component)this.mButtonPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.mMainPanel, "Center");
        this.pack();
    }

    private void btnOKActionPerformed() {
        String password = new String(this.mPasswordField.getPassword());
        String confirmedPassword = new String(this.mConfirmPasswordField.getPassword());
        if (confirmedPassword.equals(password)) {
            this.mPassword = password;
            this.mIsAccepted = true;
            this.closeDialog();
        } else {
            DialogFactory.getErrorDialog("Error", "Passwords does not match.");
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public boolean isAccepted() {
        return this.mIsAccepted;
    }

    public String getPassword() {
        return this.mPassword;
    }

    private static CredentialChangeDialog createInstance() {
        return new CredentialChangeDialog();
    }

    public static String newPassword() throws Exception {
        return EDT.runAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                CredentialChangeDialog dialog = CredentialChangeDialog.createInstance();
                dialog.setVisible(true);
                if (dialog.isAccepted()) {
                    return dialog.getPassword();
                }
                return null;
            }
        });
    }
}

