/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.xml.marshaller;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public final class GenericXmlMarshaller {
    private final JAXBContext jaxbContext;

    public GenericXmlMarshaller(Class ... classes) {
        try {
            this.jaxbContext = JAXBContext.newInstance(classes);
        }
        catch (JAXBException jaxbException) {
            throw new IllegalStateException("Error during JAXBContext initialization", jaxbException);
        }
    }

    public String marshalXmlToString(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.jaxbContext.createMarshaller().marshal(object, byteArrayOutputStream);
            return byteArrayOutputStream.toString();
        }
        catch (JAXBException jaxbException) {
            throw new IllegalArgumentException("Marshalling exception", jaxbException);
        }
    }

    public <T> T unmarshalXmlFromStream(InputStream inputStream) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        return (T)unmarshaller.unmarshal(new InputStreamReader(inputStream));
    }

    public <T> T unmarshalXmlFromString(String xmlContent) throws JAXBException {
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        return (T)unmarshaller.unmarshal(new StringReader(xmlContent));
    }
}

