/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.totp;

import com.ericsson.em.emc.UserException;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.totp.TotpConfigurationStatus;
import com.ericsson.em.emc.totp.TotpErrorCode;
import com.ericsson.em.emc.totp.TotpService;
import com.ericsson.em.emc.totp.persistence.Totp;
import com.ericsson.em.emc.totp.persistence.TotpDAO;
import com.ericsson.em.emc.totp.totpcore.authenticationcode.AuthCodeGenerator;
import com.ericsson.em.emc.totp.totpcore.authenticationcode.AuthCodeGeneratorBean;
import com.ericsson.em.emc.totp.totpcore.authenticationcode.AuthCodeVerifier;
import com.ericsson.em.emc.totp.totpcore.authenticationcode.AuthCodeVerifierBean;
import com.ericsson.em.emc.totp.totpcore.authenticationcode.HashingAlgorithm;
import com.ericsson.em.emc.totp.totpcore.authenticationcode.TOTPAuthUriData;
import com.ericsson.em.emc.totp.totpcore.secret.SecretGeneratorBean;
import com.ericsson.em.emc.totp.totpcore.time.SystemTimeProvider;
import com.ericsson.em.emc.totp.totpcore.time.TimeProvider;
import com.ericsson.lwac.cluster.ClusterException;
import com.ericsson.lwac.crypto.EncryptedField;
import com.ericsson.lwac.deployer.service.Service;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Service
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class TotpServiceBean
implements TotpService {
    private static final int TOTP_CODE_LENGTH = 6;
    private static final int TIME_PERIOD = 30;
    private static final HashingAlgorithm ALGORITHM = HashingAlgorithm.SHA1;
    private static final TimeProvider TIME_PROVIDER = new SystemTimeProvider();
    private static final AuthCodeGenerator CODE_GENERATOR = new AuthCodeGeneratorBean(HashingAlgorithm.SHA1, 6);
    private static final AuthCodeVerifier VERIFIER = new AuthCodeVerifierBean(CODE_GENERATOR, TIME_PROVIDER);
    private String validity = AuthCodeValidity.ONE_MINUTE.name();
    private AuthCodeValidity validityEnum = AuthCodeValidity.ONE_MINUTE;
    private String label = "EWP";
    public static final Predicate<String> IS_STATUS_NOT_ACTIVATED = status -> status.equalsIgnoreCase(TotpConfigurationStatus.ACTIVATION_REQUIRED.name()) || status.equalsIgnoreCase(TotpConfigurationStatus.TOTP_REGENERATE.name());
    public static final Predicate<String> IS_STATUS_ACTIVATED = status -> status.equalsIgnoreCase(TotpConfigurationStatus.ACTIVATED.name());
    public static final Predicate<String> IS_STATUS_TOTP_REGENERATE = status -> status.equalsIgnoreCase(TotpConfigurationStatus.TOTP_REGENERATE.name());
    public static final Predicate<String> IS_STATUS_ACTIVATION_REQUIRED = status -> status.equalsIgnoreCase(TotpConfigurationStatus.ACTIVATION_REQUIRED.name());
    @EJB
    private TotpDAO totpDAO;

    @PostConstruct
    public void postConstruct() throws ClusterException {
        VERIFIER.setTimePeriod(30);
        VERIFIER.setAllowedTimePeriodDiscrepancy(this.validityEnum.getDiscrepancy());
    }

    @Override
    public String generateTotpSecretKey(String identity) {
        SecretGeneratorBean secretGenerator = new SecretGeneratorBean(32);
        String secret = secretGenerator.generateSecret();
        this.createTotpEntry(identity, secret);
        return this.getTotpOauthUrl(secret);
    }

    @Override
    public Totp find(String identity) {
        return this.totpDAO.find(identity);
    }

    @Override
    public boolean isTotpActivated(String identity) {
        Totp totp = this.totpDAO.find(identity);
        return totp != null && IS_STATUS_ACTIVATED.test(totp.getConfigurationStatus());
    }

    private String getTotpOauthUrl(String secret) {
        TOTPAuthUriData data = new TOTPAuthUriData.Builder().label(this.label).secret(secret).issuer(this.label).algorithm(ALGORITHM).digits(6).period(30).build();
        return data.getTotpAuthUri();
    }

    @Override
    public void updateStatusToActivated(Totp totp) {
        totp.setConfigurationStatus(TotpConfigurationStatus.ACTIVATED.name());
        this.totpDAO.update(totp);
    }

    @Override
    public void setValidityString(String validity) {
        try {
            this.validityEnum = AuthCodeValidity.valueOf(validity);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal validity, allowed values are: " + this.getValidityList(), e);
        }
    }

    @Override
    public void onTimeout() {
    }

    @Override
    public void processAt(ZonedDateTime now) {
        TotpService.super.processAt(now);
    }

    @Override
    public String getValidity() {
        return this.validity;
    }

    public void setValidity(String validity) {
        this.validity = validity;
        this.setValidityString(validity);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public TotpConfigurationStatus getTotpActivationStatus(String identity) throws UserException {
        Totp totp = this.totpDAO.find(identity);
        if (totp == null) {
            return TotpConfigurationStatus.NOT_CONFIGURED;
        }
        if (IS_STATUS_ACTIVATED.test(totp.getConfigurationStatus())) {
            return TotpConfigurationStatus.ACTIVATED;
        }
        if (IS_STATUS_TOTP_REGENERATE.test(totp.getConfigurationStatus())) {
            return TotpConfigurationStatus.TOTP_REGENERATE;
        }
        if (IS_STATUS_ACTIVATION_REQUIRED.test(totp.getConfigurationStatus())) {
            return TotpConfigurationStatus.ACTIVATION_REQUIRED;
        }
        throw new UserExceptionBuilder(TotpErrorCode.TOTP_STATUS_INVALID).create();
    }

    @Override
    public TotpService.TotpResult verifyTotp(String identity, String code) {
        Totp totp = this.totpDAO.find(identity);
        if (totp == null) {
            throw new UserExceptionBuilder(TotpErrorCode.TOTP_NOT_CONFIGURED).create();
        }
        return this.verifyTotp(totp, code);
    }

    @Override
    public TotpService.TotpResult verifyTotp(Totp totp, String code) {
        boolean valid = VERIFIER.isValidAuthCode((String)totp.getSecret().getValue(), code);
        if (valid && IS_STATUS_ACTIVATED.test(totp.getConfigurationStatus())) {
            return new TotpService.TotpResult(TotpService.TotpStatus.VALID);
        }
        if (valid && IS_STATUS_NOT_ACTIVATED.test(totp.getConfigurationStatus())) {
            return new TotpService.TotpResult(TotpService.TotpStatus.VALID);
        }
        return new TotpService.TotpResult(TotpService.TotpStatus.TOTP_INVALID);
    }

    private void createTotpEntry(String identity, String secret) {
        Totp totp = this.totpDAO.find(identity);
        if (totp == null) {
            this.totpDAO.create(new Totp(identity, secret, TotpConfigurationStatus.ACTIVATION_REQUIRED.name()));
        } else {
            if (IS_STATUS_ACTIVATED.test(totp.getConfigurationStatus())) {
                throw new UserExceptionBuilder(TotpErrorCode.GENERATE_TOTP_NOT_ALLOWED).create();
            }
            if (IS_STATUS_NOT_ACTIVATED.test(totp.getConfigurationStatus())) {
                if (secret == null) {
                    throw new UserExceptionBuilder(TotpErrorCode.SECRET_MISSING).create();
                }
                EncryptedField data = new EncryptedField();
                data.setValue((Object)secret);
                totp.setSecret((EncryptedField<String>)data);
                this.totpDAO.update(totp);
            }
        }
    }

    public String getValidityList() {
        return Arrays.stream(AuthCodeValidity.values()).map(Enum::name).collect(Collectors.joining(", "));
    }

    @Override
    public boolean updateStatusToTOTPRegenerate(String identity) {
        Totp entity = this.totpDAO.find(identity);
        if (entity != null && (TotpConfigurationStatus.ACTIVATED.name().equalsIgnoreCase(entity.getConfigurationStatus()) || TotpConfigurationStatus.TOTP_REGENERATE.name().equalsIgnoreCase(entity.getConfigurationStatus()))) {
            entity.setConfigurationStatus(TotpConfigurationStatus.TOTP_REGENERATE.name());
            this.totpDAO.update(entity);
            return true;
        }
        return false;
    }

    @Override
    public void removeTOTPSecret(String identity) {
        Totp totpEntry = this.totpDAO.find(identity);
        if (totpEntry != null) {
            this.totpDAO.delete(identity);
        }
    }

    public static enum AuthCodeValidity {
        THIRTY_SECONDS(0),
        ONE_MINUTE(1),
        THREE_MINUTES(5);

        private final int discrepancy;

        private AuthCodeValidity(int discrepancy) {
            this.discrepancy = discrepancy;
        }

        public int getDiscrepancy() {
            return this.discrepancy;
        }
    }
}

