/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.pincode;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.credential.CredentialManager;
import com.ericsson.em.emc.credential.CredentialOwner;
import com.ericsson.em.emc.credential.hash.HashManager;
import com.ericsson.em.emc.credential.persistence.Credential;
import com.ericsson.em.emc.credential.persistence.CredentialHistory;
import com.ericsson.em.emc.credential.persistence.CredentialHistoryDAO;
import com.ericsson.em.emc.credential.persistence.CredentialType;
import com.ericsson.em.emc.pincode.PinCodePolicyCallback;
import com.ericsson.em.emc.pincode.PinCodeService;
import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.security.HashVersion;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJB;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.joda.time.LocalDate;

@Service
public class PinCodeServiceBean
implements PinCodeService {
    private static final int MIN_ALLOWED_PINCODE_LENGTH = 4;
    private static final int MAX_ALLOWED_PINCODE_LENGTH = 10;
    private static final int MIN_ALLOWED_CONSECUTIVE_DIGITS = 2;
    private static final int MIN_ALLOWED_REPEATED_DIGITS = 2;
    private static final int MIN_ALLOWED_LAST_DIGITS_OF_MSISDN = 1;
    private static final int MIN_ALLOWED_FIRST_DIGITS_OF_IDENTIFICATION_NUMBER = 1;
    private static final int MIN_ALLOWED_LAST_DIGITS_OF_IDENTIFICATION_NUMBER = 1;
    private static final int MIN_ALLOWED_PREVIOUS_PIN_CODES_TO_MATCH = 1;
    private static final int MIN_ALLOWED_DAYS_BEFORE_CHANGING_PIN_CODE = 1;
    private static final int MAX_ALLOWED_DAYS_BEFORE_CHANGING_PIN_CODE = 365;
    @EJB
    private CredentialManager credentialManager;
    @EJB
    private CredentialHistoryDAO credentialHistoryDAO;
    @EJB
    private HashManager hashManager;
    private Integer minPinCodeLength;
    private Integer maxPinCodeLength;
    private Integer maxNumberOfConsecutiveDigits;
    private Integer maxNumberOfRepeatedDigits;
    private final List<Pattern> denyByRegularExpressions = new CopyOnWriteArrayList<Pattern>();
    private Integer numberOfLastDigitsOfMsisdn;
    private final List<String> denyByBirthDate = new CopyOnWriteArrayList<String>();
    private Integer numberOfFirstDigitsOfIdentificationNumber;
    private Integer numberOfLastDigitsOfIdentificationNumber;
    private Integer numberOfPreviousPinCodesToMatch;
    private Integer numberOfDaysBeforeChangingPinCode;
    private LocalDate testDate;

    public void setMinimumPinCodeLength(int value) {
        this.minPinCodeLength = value;
    }

    @Override
    public Integer getMinimumPinCodeLength() {
        return this.minPinCodeLength;
    }

    public void setMaximumPinCodeLength(int value) {
        this.maxPinCodeLength = value;
    }

    @Override
    public Integer getMaximumPinCodeLength() {
        return this.maxPinCodeLength;
    }

    public void setMaximumNumberOfConsecutiveDigits(int value) {
        this.maxNumberOfConsecutiveDigits = value;
    }

    public void setMaximumNumberOfRepeatedDigits(int value) {
        this.maxNumberOfRepeatedDigits = value;
    }

    public void setDenyByRegularExpressions(List<String> values) {
        this.denyByRegularExpressions.clear();
        if (values != null) {
            for (String value : values) {
                this.denyByRegularExpressions.add(Pattern.compile(value));
            }
            return;
        }
    }

    public void setNumberOfLastDigitsOfMsisdn(int value) {
        this.numberOfLastDigitsOfMsisdn = value;
    }

    public void setDenyByBirthDate(List<String> values) {
        this.denyByBirthDate.clear();
        if (values != null) {
            this.denyByBirthDate.addAll(values);
            return;
        }
    }

    public void setNumberOfFirstDigitsOfIdentificationNumber(int value) {
        this.numberOfFirstDigitsOfIdentificationNumber = value;
    }

    public void setNumberOfLastDigitsOfIdentificationNumber(int value) {
        this.numberOfLastDigitsOfIdentificationNumber = value;
    }

    public void setNumberOfPreviousPinCodesToMatch(int value) {
        this.numberOfPreviousPinCodesToMatch = value;
    }

    public void setNumberOfDaysBeforeChangingPinCode(int value) {
        this.numberOfDaysBeforeChangingPinCode = value;
    }

    @PostConstruct
    public void postConstruct() {
        this.validateProperties();
    }

    public void validateProperties() {
        if (this.minPinCodeLength != null && (this.minPinCodeLength < 4 || this.minPinCodeLength > 10)) {
            throw new RuntimeException(String.format("Invalid PIN code configuration. Minimum supported PIN code length is %d digits.", 4));
        }
        if (this.maxPinCodeLength != null && (this.maxPinCodeLength > 10 || this.maxPinCodeLength < 4)) {
            throw new RuntimeException(String.format("Invalid PIN code configuration. Maximum supported PIN code length is %d digits.", 10));
        }
        if (this.minPinCodeLength != null && this.maxPinCodeLength != null && this.maxPinCodeLength < this.minPinCodeLength) {
            throw new RuntimeException("Invalid PIN code configuration. Maximum PIN code length cannot be less than the minimum length.");
        }
        if (this.maxNumberOfConsecutiveDigits != null && this.maxNumberOfConsecutiveDigits < 2) {
            throw new RuntimeException(String.format("Invalid PIN code configuration. Maximum number of consecutive digits cannot be less than %d.", 2));
        }
        if (this.maxNumberOfRepeatedDigits != null && this.maxNumberOfRepeatedDigits < 2) {
            throw new RuntimeException(String.format("Invalid PIN code configuration. Maximum number of repeated digits cannot be less than %d.", 2));
        }
        if (this.numberOfLastDigitsOfMsisdn != null && this.numberOfLastDigitsOfMsisdn < 1) {
            throw new RuntimeException(String.format("Invalid PIN code configuration. The number of last digits of MSISDN cannot be less than %d.", 1));
        }
        if (!this.denyByBirthDate.isEmpty()) {
            Pattern datePattern = Pattern.compile("[yMd]+");
            SimpleDateFormat sdf = new SimpleDateFormat();
            for (String s : this.denyByBirthDate) {
                if (!datePattern.matcher(s).matches()) {
                    throw new RuntimeException(String.format("Invalid PIN code configuration. A birth date string can only contain the characters 'y', 'M', and 'd'. Current string is: %s", s));
                }
                try {
                    sdf.applyPattern(s);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(String.format("Invalid PIN code configuration. The following birth date syntax is not valid: %s", s));
                }
            }
        }
        if (this.numberOfFirstDigitsOfIdentificationNumber != null && this.numberOfFirstDigitsOfIdentificationNumber < 1) {
            throw new RuntimeException(String.format("Invalid PIN code configuration. The number of first digits of identification number cannot be less than %d.", 1));
        }
        if (this.numberOfLastDigitsOfIdentificationNumber != null && this.numberOfLastDigitsOfIdentificationNumber < 1) {
            throw new RuntimeException(String.format("Invalid PIN code configuration. The number of last digits of identification number cannot be less than %d.", 1));
        }
        if (this.numberOfPreviousPinCodesToMatch != null && this.numberOfPreviousPinCodesToMatch < 1) {
            throw new RuntimeException(String.format("Invalid PIN code configuration. The number of previous PIN codes to match cannot be less than %d.", 1));
        }
        if (this.numberOfDaysBeforeChangingPinCode != null && (this.numberOfDaysBeforeChangingPinCode < 1 || this.numberOfDaysBeforeChangingPinCode > 365)) {
            throw new RuntimeException(String.format("Invalid PIN code configuration. The number of days before the PIN code must be changed cannot be less than %d or more than %d.", 1, 365));
        }
    }

    @Override
    public void validatePinCode(CredentialOwner credentialOwner, String pinCode, PinCodePolicyCallback callback) {
        if (pinCode == null) {
            throw new IllegalArgumentException("Parameter 'pinCode' cannot be null.");
        }
        this.validateMinimumPinCodeLength(pinCode);
        this.validateMaximumPinCodeLength(pinCode);
        this.validateMaximumNumberOfConsecutiveDigits(pinCode);
        this.validateMaximumNumberOfRepeatedDigits(pinCode);
        this.validateRegularExpressions(pinCode);
        this.validateNumberOfLastDigitsOfMsisdn(credentialOwner, pinCode);
        this.validatePasswordHistory(credentialOwner, pinCode);
        this.validateBirthDate(credentialOwner, pinCode, callback);
        this.validateNumberOfFirstDigitsOfIdentificationNumber(credentialOwner, pinCode, callback);
        this.validateNumberOfLastDigitsOfIdentificationNumber(credentialOwner, pinCode, callback);
    }

    private void validateMinimumPinCodeLength(String pinCode) {
        if (this.minPinCodeLength != null && pinCode.length() < this.minPinCodeLength) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PINCODE_TOO_SHORT).add("min", this.minPinCodeLength).create();
        }
    }

    private void validateMaximumPinCodeLength(String pinCode) {
        if (this.maxPinCodeLength != null && pinCode.length() > this.maxPinCodeLength) {
            throw new UserExceptionBuilder(CoreUserErrorCode.PINCODE_TOO_LONG).add("max", this.maxPinCodeLength).create();
        }
    }

    private void validateMaximumNumberOfConsecutiveDigits(String pinCode) {
        if (this.maxNumberOfConsecutiveDigits != null) {
            int len = pinCode.length();
            block0: for (int i = 0; i < len; ++i) {
                char c = pinCode.charAt(i);
                int n = 1;
                for (int j = i + 1; j < len; ++j) {
                    if ((c = (char)(c + '\u0001')) > '9') {
                        c = '0';
                    }
                    if (pinCode.charAt(j) != c) continue block0;
                    if (++n <= this.maxNumberOfConsecutiveDigits) continue;
                    throw new UserExceptionBuilder(CoreUserErrorCode.TOO_MANY_CONSECUTIVE_DIGITS_IN_PINCODE).add("max", this.maxNumberOfConsecutiveDigits).create();
                }
            }
        }
    }

    private void validateMaximumNumberOfRepeatedDigits(String pinCode) {
        if (this.maxNumberOfRepeatedDigits != null) {
            int len = pinCode.length();
            for (int i = 0; i < len; ++i) {
                char c = pinCode.charAt(i);
                int n = 1;
                for (int j = i + 1; j < len && pinCode.charAt(j) == c; ++j) {
                    if (++n <= this.maxNumberOfRepeatedDigits) continue;
                    throw new UserExceptionBuilder(CoreUserErrorCode.TOO_MANY_REPEATED_DIGITS_IN_PINCODE).add("max", this.maxNumberOfRepeatedDigits).create();
                }
            }
        }
    }

    private void validateRegularExpressions(String pinCode) {
        if (this.denyByRegularExpressions != null && !this.denyByRegularExpressions.isEmpty()) {
            for (Pattern p : this.denyByRegularExpressions) {
                if (!p.matcher(pinCode).matches()) continue;
                throw new UserExceptionBuilder(CoreUserErrorCode.PINCODE_DENIED_BY_MATCHING_REGULAR_EXPRESSION).create();
            }
        }
    }

    private void validateNumberOfLastDigitsOfMsisdn(CredentialOwner credentialOwner, String pinCode) {
        if (this.numberOfLastDigitsOfMsisdn != null) {
            if (credentialOwner == null) {
                throw new IllegalArgumentException("Parameter 'credentialOwner' cannot be null.");
            }
            String msisdn = credentialOwner.getMsisdn();
            if (msisdn == null) {
                return;
            }
            int startIndex = msisdn.length() - this.numberOfLastDigitsOfMsisdn;
            if (startIndex < 0) {
                throw new RuntimeException(String.format("Invalid PIN code configuration. The number of last digits (%d) of MSISDN is greater than actual MSISDN: %s", this.numberOfLastDigitsOfMsisdn, msisdn));
            }
            String msisdnToMatch = msisdn.substring(startIndex);
            if (pinCode.contains(msisdnToMatch)) {
                throw new UserExceptionBuilder(CoreUserErrorCode.PINCODE_DENIED_BY_MATCHING_MSISDN).create();
            }
        }
    }

    private void validateBirthDate(CredentialOwner credentialOwner, String pinCode, PinCodePolicyCallback callback) {
        if (!this.denyByBirthDate.isEmpty()) {
            if (credentialOwner == null) {
                throw new IllegalArgumentException("Parameter 'credentialOwner' cannot be null.");
            }
            if (callback == null) {
                throw new IllegalArgumentException("Parameter 'callback' cannot be null.");
            }
            LocalDate birthDate = callback.getBirthDate(credentialOwner);
            if (birthDate == null) {
                return;
            }
            for (String birthDatePattern : this.denyByBirthDate) {
                if (!pinCode.equals(birthDate.toString(birthDatePattern))) continue;
                throw new UserExceptionBuilder(CoreUserErrorCode.PINCODE_DENIED_BY_MATCHING_BIRTH_DATE).create();
            }
        }
    }

    private void validateNumberOfFirstDigitsOfIdentificationNumber(CredentialOwner credentialOwner, String pinCode, PinCodePolicyCallback callback) {
        if (this.numberOfFirstDigitsOfIdentificationNumber != null) {
            if (credentialOwner == null) {
                throw new IllegalArgumentException("Parameter 'credentialOwner' cannot be null.");
            }
            if (callback == null) {
                throw new IllegalArgumentException("Parameter 'callback' cannot be null.");
            }
            List<String> identificationNumbers = callback.getIdentificationNumbers(credentialOwner);
            if (identificationNumbers == null || identificationNumbers.isEmpty()) {
                return;
            }
            for (String identificationNumber : identificationNumbers) {
                if (identificationNumber.length() < this.numberOfFirstDigitsOfIdentificationNumber) continue;
                String identificationNumberToMatch = identificationNumber.substring(0, this.numberOfFirstDigitsOfIdentificationNumber);
                if (!pinCode.toUpperCase().contains(identificationNumberToMatch.toUpperCase())) continue;
                throw new UserExceptionBuilder(CoreUserErrorCode.PINCODE_DENIED_BY_MATCHING_IDENTIFICATION_NUMBER).create();
            }
        }
    }

    private void validateNumberOfLastDigitsOfIdentificationNumber(CredentialOwner credentialOwner, String pinCode, PinCodePolicyCallback callback) {
        if (this.numberOfLastDigitsOfIdentificationNumber != null) {
            if (credentialOwner == null) {
                throw new IllegalArgumentException("Parameter 'credentialOwner' cannot be null.");
            }
            if (callback == null) {
                throw new IllegalArgumentException("Parameter 'callback' cannot be null.");
            }
            List<String> identificationNumbers = callback.getIdentificationNumbers(credentialOwner);
            if (identificationNumbers == null || identificationNumbers.isEmpty()) {
                return;
            }
            for (String identificationNumber : identificationNumbers) {
                if (identificationNumber.length() < this.numberOfLastDigitsOfIdentificationNumber) continue;
                String identificationNumberToMatch = identificationNumber.substring(identificationNumber.length() - this.numberOfLastDigitsOfIdentificationNumber);
                if (!pinCode.toUpperCase().contains(identificationNumberToMatch.toUpperCase())) continue;
                throw new UserExceptionBuilder(CoreUserErrorCode.PINCODE_DENIED_BY_MATCHING_IDENTIFICATION_NUMBER).create();
            }
        }
    }

    private void validatePasswordHistory(CredentialOwner credentialOwner, String pinCode) {
        if (this.numberOfPreviousPinCodesToMatch != null) {
            Long saltId = credentialOwner.getCredentialOwnerReference().getId();
            HashMap<HashVersion, byte[]> differentVersionHashes = new HashMap<HashVersion, byte[]>();
            Credential credential = this.credentialManager.getCredentialByOwnerAndCredentialType(credentialOwner, "pincode");
            if (credential == null) {
                return;
            }
            byte[] hashedPinCode = this.getCredentialHashForHashVersion(saltId, pinCode, credential.getHashVersion(), differentVersionHashes);
            if (Arrays.equals(hashedPinCode, credential.getHashedCredential())) {
                throw new UserExceptionBuilder(CoreUserErrorCode.PINCODE_ALREADY_USED_BEFORE).create();
            }
            if (this.numberOfPreviousPinCodesToMatch > 1) {
                CredentialType credentialType = this.credentialManager.getCredentialType("pincode");
                List<CredentialHistory> history = this.credentialHistoryDAO.findLatestByCredentialOwnerAndCredentialType(credentialOwner, credentialType, this.numberOfPreviousPinCodesToMatch - 1);
                for (CredentialHistory ch : history) {
                    hashedPinCode = this.getCredentialHashForHashVersion(saltId, pinCode, ch.getHashVersion(), differentVersionHashes);
                    if (!Arrays.equals(hashedPinCode, ch.getHashedPassword())) continue;
                    throw new UserExceptionBuilder(CoreUserErrorCode.PINCODE_ALREADY_USED_BEFORE).create();
                }
            }
        }
    }

    private byte[] getCredentialHashForHashVersion(Long databaseId, String credential, HashVersion hashVersion, Map<HashVersion, byte[]> map) {
        byte[] hash = map.get((Object)hashVersion);
        if (hash == null) {
            hash = this.hashManager.getHashedCredential(databaseId, credential, hashVersion);
            map.put(hashVersion, hash);
        }
        return hash;
    }

    @Override
    public void validatePinCodeExpiry(Credential credential, CredentialOwner credentialOwner) {
        if (this.numberOfDaysBeforeChangingPinCode != null) {
            if (credential == null) {
                return;
            }
            LocalDate expiryDate = new LocalDate(credential.getCreated()).plusDays(this.numberOfDaysBeforeChangingPinCode);
            if (expiryDate.isBefore(this.getCurrentDate())) {
                throw new UserExceptionBuilder(CoreUserErrorCode.PINCODE_HAS_EXPIRED).create();
            }
        }
    }

    public void clearProperties() {
        this.minPinCodeLength = null;
        this.maxPinCodeLength = null;
        this.maxNumberOfConsecutiveDigits = null;
        this.maxNumberOfRepeatedDigits = null;
        this.denyByRegularExpressions.clear();
        this.numberOfLastDigitsOfMsisdn = null;
        this.denyByBirthDate.clear();
        this.numberOfFirstDigitsOfIdentificationNumber = null;
        this.numberOfLastDigitsOfIdentificationNumber = null;
        this.numberOfPreviousPinCodesToMatch = null;
        this.numberOfDaysBeforeChangingPinCode = null;
    }

    @Override
    public void setTestDate(LocalDate date) {
        this.testDate = date;
    }

    private LocalDate getCurrentDate() {
        if (this.testDate == null) {
            return LocalDate.now();
        }
        return this.testDate;
    }
}

