/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.otp;

import com.ericsson.em.emc.notificationclient.NotificationChannelType;
import com.ericsson.lwac.utilities.TokenGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class OtpSettings {
    private static final int MAX_NUMBER_OF_SECURITY_QUESTIONS_FOR_RESET = 5;
    private final TokenGenerator tokenGenerator = new TokenGenerator();
    private int otpValidityMinutes = 10;
    private int numberOfTries = 3;
    private int otpWindowSize = 10;
    private int otpWindowAge = 600;
    private int otpQuarantineTime = 3600;
    private int otpFailureLimit = 20;
    private int otpLength = 4;
    private boolean useLetters = false;
    private boolean useDigits = true;
    private String excludedLetters = "loi";
    private String excludedDigits = "";
    private boolean genericErrorOnFailure = false;
    private int numberOfSecurityQuestionsForReset = 0;
    private List<NotificationChannelType> allowedNotificationChannels = Arrays.asList(NotificationChannelType.values());

    public OtpSettings() {
    }

    OtpSettings(List<String> settings) {
        if (settings != null) {
            this.otpValidityMinutes = OtpSettings.getIntegerProperty(this.otpValidityMinutes, "OtpValidityMinutes:", settings);
            this.numberOfTries = OtpSettings.getIntegerProperty(this.numberOfTries, "NumberOfTries:", settings);
            this.otpWindowSize = OtpSettings.getIntegerProperty(this.otpWindowSize, "OtpWindowSize:", settings);
            this.otpWindowAge = OtpSettings.getIntegerProperty(this.otpWindowAge, "OtpWindowAge:", settings);
            this.otpQuarantineTime = OtpSettings.getIntegerProperty(this.otpQuarantineTime, "OtpQuarantineTime:", settings);
            this.otpFailureLimit = OtpSettings.getIntegerProperty(this.otpFailureLimit, "OtpFailureLimit:", settings);
            this.otpLength = OtpSettings.getIntegerProperty(this.otpLength, "OtpLength:", settings);
            this.tokenGenerator.setTokenLength(this.otpLength);
            this.useLetters = OtpSettings.getBooleanProperty(this.useLetters, "UseLetters:", settings);
            this.tokenGenerator.setUseLetters(this.useLetters);
            this.useDigits = OtpSettings.getBooleanProperty(this.useDigits, "UseDigits:", settings);
            this.tokenGenerator.setUseDigits(this.useDigits);
            this.excludedLetters = OtpSettings.getStringProperty(this.excludedLetters, "ExcludedLetters:", settings);
            this.tokenGenerator.setExcludedLetters(this.excludedLetters);
            this.excludedDigits = OtpSettings.getStringProperty(this.excludedDigits, "ExcludedDigits:", settings);
            this.tokenGenerator.setExcludedDigits(this.excludedDigits);
            this.allowedNotificationChannels = OtpSettings.getAllowedNotificationChannelsProperty(this.allowedNotificationChannels, settings);
            this.genericErrorOnFailure = OtpSettings.getBooleanProperty(this.genericErrorOnFailure, "OtpGenericErrorOnFailure:", settings);
            this.setNumberOfSecurityQuestionsForReset(OtpSettings.getIntegerProperty(this.numberOfSecurityQuestionsForReset, "NumberOfSecurityQuestionsForReset:", settings));
        }
        this.tokenGenerator.start();
    }

    private static int getIntegerProperty(int defaultValue, String propertyName, List<String> settings) {
        for (String property : settings) {
            if (!property.startsWith(propertyName)) continue;
            return Integer.parseInt(property.replaceFirst(propertyName, ""));
        }
        return defaultValue;
    }

    private static boolean getBooleanProperty(boolean defaultValue, String propertyName, List<String> settings) {
        for (String property : settings) {
            if (!property.startsWith(propertyName)) continue;
            return Boolean.parseBoolean(property.replaceFirst(propertyName, ""));
        }
        return defaultValue;
    }

    private static String getStringProperty(String defaultValue, String propertyName, List<String> settings) {
        for (String property : settings) {
            if (!property.startsWith(propertyName)) continue;
            return property.replaceFirst(propertyName, "");
        }
        return defaultValue;
    }

    private static List<NotificationChannelType> getAllowedNotificationChannelsProperty(List<NotificationChannelType> defaultValue, List<String> settings) {
        String propertyName = "AllowedNotificationChannels:";
        for (String property : settings) {
            if (!property.startsWith(propertyName)) continue;
            String stringList = property.replaceFirst(propertyName, "");
            return Arrays.stream(stringList.split(",")).map(NotificationChannelType::valueOf).collect(Collectors.toList());
        }
        return defaultValue;
    }

    public int getOtpValidityMinutes() {
        return this.otpValidityMinutes;
    }

    public void setOtpValidityMinutes(int otpValidityMinutes) {
        this.otpValidityMinutes = otpValidityMinutes;
    }

    public int getNumberOfTries() {
        return this.numberOfTries;
    }

    public void setNumberOfTries(int numberOfTries) {
        this.numberOfTries = numberOfTries;
    }

    public int getOtpWindowSize() {
        return this.otpWindowSize;
    }

    public void setOtpWindowSize(int otpWindowSize) {
        this.otpWindowSize = otpWindowSize;
    }

    public int getOtpWindowAge() {
        return this.otpWindowAge;
    }

    public void setOtpWindowAge(int otpWindowAge) {
        this.otpWindowAge = otpWindowAge;
    }

    public int getOtpQuarantineTime() {
        return this.otpQuarantineTime;
    }

    public void setOtpQuarantineTime(int otpQuarantineTime) {
        this.otpQuarantineTime = otpQuarantineTime;
    }

    public int getOtpFailureLimit() {
        return this.otpFailureLimit;
    }

    public void setOtpFailureLimit(int otpFailureLimit) {
        this.otpFailureLimit = otpFailureLimit;
    }

    public int getOtpLength() {
        return this.otpLength;
    }

    public void setOtpLength(int otpLength) {
        this.otpLength = otpLength;
    }

    public boolean isUseLetters() {
        return this.useLetters;
    }

    public void setUseLetters(boolean useLetters) {
        this.useLetters = useLetters;
    }

    public boolean isUseDigits() {
        return this.useDigits;
    }

    public void setUseDigits(boolean useDigits) {
        this.useDigits = useDigits;
    }

    public String getExcludedLetters() {
        return this.excludedLetters;
    }

    public void setExcludedLetters(String excludedLetters) {
        this.excludedLetters = excludedLetters;
    }

    public String getExcludedDigits() {
        return this.excludedDigits;
    }

    public void setExcludedDigits(String excludedDigits) {
        this.excludedDigits = excludedDigits;
    }

    public TokenGenerator getTokenGenerator() {
        return this.tokenGenerator;
    }

    public List<NotificationChannelType> getAllowedNotificationChannels() {
        return this.allowedNotificationChannels;
    }

    public void setAllowedNotificationChannels(List<NotificationChannelType> allowedNotificationChannels) {
        this.allowedNotificationChannels = allowedNotificationChannels;
    }

    public boolean hasGenericErrorOnFailure() {
        return this.genericErrorOnFailure;
    }

    public void setGenericErrorOnFailure(boolean genericErrorOnFailure) {
        this.genericErrorOnFailure = genericErrorOnFailure;
    }

    public String createToken() {
        return this.tokenGenerator.createToken();
    }

    public int getNumberOfSecurityQuestionsForReset() {
        return this.numberOfSecurityQuestionsForReset;
    }

    public void setNumberOfSecurityQuestionsForReset(int numberOfSecurityQuestionsForReset) {
        this.numberOfSecurityQuestionsForReset = numberOfSecurityQuestionsForReset > 5 ? 5 : numberOfSecurityQuestionsForReset;
    }
}

