/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.otp;

import com.ericsson.em.emc.credential.hash.HashManager;
import com.ericsson.em.emc.entities.OtpEntity;
import com.ericsson.em.emc.notificationclient.NotificationChannelType;
import com.ericsson.em.emc.operations.otp.OtpOperations;
import com.ericsson.em.emc.otp.OtpErrorCode;
import com.ericsson.em.emc.otp.OtpHistory;
import com.ericsson.em.emc.otp.OtpHistoryKey;
import com.ericsson.em.emc.otp.OtpLimitsException;
import com.ericsson.em.emc.otp.OtpLimitsFaultIndicationDescription;
import com.ericsson.em.emc.otp.OtpService;
import com.ericsson.em.emc.otp.OtpServiceListener;
import com.ericsson.em.emc.otp.OtpSettings;
import com.ericsson.em.emc.otp.persistence.Otp;
import com.ericsson.em.emc.otp.persistence.OtpDAO;
import com.ericsson.lwac.ErrorCode;
import com.ericsson.lwac.cluster.ClusterException;
import com.ericsson.lwac.cluster.ClusterService;
import com.ericsson.lwac.database.persistence.ResultSetProcessor;
import com.ericsson.lwac.database.persistence.TransacitonAwareProcessor;
import com.ericsson.lwac.deployer.ApplicationContext;
import com.ericsson.lwac.deployer.service.Service;
import com.ericsson.lwac.deployer.service.ServiceProperty;
import com.ericsson.lwac.faultindication.FaultIndication;
import com.ericsson.lwac.faultindication.FaultIndicationService;
import com.ericsson.lwac.timer.TimerCondition;
import com.ericsson.lwac.timer.TimerRegistration;
import com.ericsson.lwac.timer.TimerService;
import com.ericsson.lwac.utilities.ByteArrayUtilities;
import com.ericsson.lwac.utilities.Preconditions;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import java.security.SecureRandom;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class OtpServiceBean
implements OtpService {
    @Resource
    private ClusterService clusterService;
    @Resource
    private TimerService timerService;
    @Resource
    private FaultIndicationService faultIndicationService;
    @Resource
    private ApplicationContext applicationContext;
    private String schedule = "* * * * *";
    @EJB
    private OtpDAO otpDAO;
    private final EnumMap<OtpService.OtpStatus, ErrorCode> errorCodesFromValidationResults = new EnumMap(OtpService.OtpStatus.class);
    private ConcurrentMap<String, byte[]> recentOtpHistory;
    private final ConcurrentHashMap<OtpOperations, OtpSettings> otpSettings = new ConcurrentHashMap();
    @EJB
    private HashManager hashManager;
    private final SecureRandom random = new SecureRandom();
    private static final Logger logger = LoggerFactory.getLogger(OtpServiceBean.class);
    private final ConcurrentHashMap<OtpOperations, OtpServiceListener> otpServiceListeners = new ConcurrentHashMap();
    private static final Integer DEFAULT_PRIORITY = null;
    private Integer priority = DEFAULT_PRIORITY;
    private int clusterPort = 0;

    public OtpServiceBean() {
        this.errorCodesFromValidationResults.put(OtpService.OtpStatus.VALID, null);
        this.errorCodesFromValidationResults.put(OtpService.OtpStatus.INVALID_OTP, OtpErrorCode.OTP_INVALID);
        this.errorCodesFromValidationResults.put(OtpService.OtpStatus.OTP_NOT_FOUND, OtpErrorCode.OTP_NOT_FOUND);
    }

    @PostConstruct
    public void postConstruct() throws ClusterException {
        this.recentOtpHistory = this.clusterPort > 0 ? this.clusterService.createReplicatedMap(this.applicationContext.getBeanId(), this.clusterPort) : this.clusterService.createReplicatedMap(this.applicationContext.getBeanId());
        this.timerService.registerTimerListener(new TimerRegistration.TimerRegistrationBuilder().beanId(this.applicationContext.getBeanId()).timerListener(this).pattern(this.schedule).timerCondition(TimerCondition.ALL_NODES).priority(this.priority).build());
        if (this.otpSettings.isEmpty()) {
            this.setDefaultSettings();
        }
    }

    private void setDefaultSettings() {
        for (OtpOperations operationType : OtpOperations.values()) {
            this.otpSettings.put(operationType, new OtpSettings(null));
        }
    }

    @PreDestroy
    public void preDestroy() {
        this.clusterService.destroyMap(this.recentOtpHistory);
    }

    @Override
    public void onTimeout() {
        if (this.clusterService.isCoordinator()) {
            this.processAt(DateTime.now());
        }
    }

    @Override
    public int getHistoryMapSize() {
        return this.recentOtpHistory.size();
    }

    @Override
    public boolean supportGenericErrorOnFailure() {
        return this.otpSettings.get((Object)OtpOperations.OTP_OPERATION_CREDENTIALS_RESET).hasGenericErrorOnFailure();
    }

    @Override
    public OtpHistory getOtpHistory(String identification, OtpOperations operationType) {
        return this.getFromRecentOtpHistory(OtpHistoryKey.valueOf(identification, operationType)).orElse(null);
    }

    @Override
    public void processAt(DateTime now) {
        this.processOTPHistory(now);
    }

    @Override
    public void processOTPHistory(DateTime now) {
        this.otpDAO.processOtp(new ExpiredOtpProcessor(), now);
        this.internalProcessOtpHistory(now);
    }

    private void internalProcessOtpHistory(DateTime now) {
        LinkedList<String> expiredOtpHistoryKeys = new LinkedList<String>();
        for (Map.Entry entry : this.recentOtpHistory.entrySet()) {
            OtpHistory history = this.deserializeOtpHistory((byte[])entry.getValue());
            OtpSettings settings = this.otpSettings.get((Object)history.getOtpOperation());
            history = history.clearHistoryExpiredOTPs(now, Math.max(settings.getOtpQuarantineTime(), settings.getOtpValidityMinutes() * 60));
            this.updateRecentOtpHistory((String)entry.getKey(), history);
            if (!history.isExpired(now)) continue;
            expiredOtpHistoryKeys.add((String)entry.getKey());
        }
        expiredOtpHistoryKeys.forEach(this.recentOtpHistory::remove);
    }

    @Override
    public void setQuarantineDate(String identification, OtpOperations operationType, DateTime quarantineDate) {
        OtpHistoryKey otpHistoryKey = OtpHistoryKey.valueOf(identification, operationType);
        this.getFromRecentOtpHistory(otpHistoryKey).map(otpHistory -> otpHistory.setQuarantineEndDate(quarantineDate)).ifPresent(otpHistory -> this.updateRecentOtpHistory(otpHistoryKey, (OtpHistory)otpHistory));
    }

    @Override
    public String generateOtp(OtpEntity otpEntity) {
        DateTime now = new DateTime();
        OtpHistoryKey otpHistoryKey = otpEntity.getGeneratedBy() != null && !otpEntity.getGeneratedBy().isEmpty() ? OtpHistoryKey.valueOf(this.getIdentificationForGenericOTP(otpEntity.getGeneratedFor(), otpEntity.getGeneratedBy()), otpEntity.getOperationType()) : OtpHistoryKey.valueOf(otpEntity.getIdentification(), otpEntity.getOperationType());
        Optional<OtpHistory> otpHistory = this.getFromRecentOtpHistory(otpHistoryKey);
        if (otpHistory.isPresent()) {
            this.checkIfInQuarantine(otpHistory.get(), otpHistoryKey, now);
            this.checkOtpFailureCounter(otpHistory.get(), otpHistoryKey, now);
            this.checkOutstandingOTPs(otpHistory.get(), otpHistoryKey, now);
        }
        return this.makeNewOtp(otpEntity, now);
    }

    private void sendFaultIndication(OtpLimitsFaultIndicationDescription faultIndicationType, OtpHistory otpHistory, String identification) {
        int totalFailuresCount = otpHistory.getRecentFailureCount();
        int outstandingOtpsCount = otpHistory.countOutstandingOTPs();
        this.faultIndicationService.report(FaultIndication.newBuilder(faultIndicationType).additionalInformation("id", identification).additionalInformation("failures", String.valueOf(totalFailuresCount)).additionalInformation("outstandingOTPs", String.valueOf(outstandingOtpsCount)).build());
    }

    private void checkIfInQuarantine(OtpHistory otpHistory, OtpHistoryKey otpHistoryKey, DateTime now) {
        if (otpHistory.isInQuarantineAt(now)) {
            this.sendFaultIndication(OtpLimitsFaultIndicationDescription.OTP_GENERATION_RATE_LIMIT_REACHED, otpHistory, otpHistoryKey.getIdentification());
            OtpSettings otpSettings = this.otpSettings.get((Object)otpHistoryKey.getOperationType());
            long otpWindowInMinutes = TimeUnit.SECONDS.toMinutes(otpSettings.getOtpWindowAge());
            throw new OtpLimitsException(OtpErrorCode.OTP_GENERATION_RATE_LIMIT_EXCEEDED, otpWindowInMinutes);
        }
    }

    private void checkOtpFailureCounter(OtpHistory otpHistory, OtpHistoryKey otpHistoryKey, DateTime now) {
        int otpFailureLimit;
        OtpSettings otpSettings = this.otpSettings.get((Object)otpHistoryKey.getOperationType());
        int otpQuarantineTime = otpSettings.getOtpQuarantineTime();
        if (!otpHistory.isOTPGenerationAllowedByCounter(now, otpQuarantineTime, otpFailureLimit = otpSettings.getOtpFailureLimit())) {
            String identification = otpHistoryKey.getIdentification();
            this.sendFaultIndication(OtpLimitsFaultIndicationDescription.OTP_GENERATION_FAILURE_COUNTER_EXCEEDED, otpHistory, identification);
            this.setQuarantineDate(identification, otpHistoryKey.getOperationType(), now.plusSeconds(otpQuarantineTime));
            long otpDurationTimeInMinutes = TimeUnit.SECONDS.toMinutes(otpQuarantineTime);
            throw new OtpLimitsException(OtpErrorCode.OTP_GENERATION_FAILURE_COUNTER_EXCEEDED, otpDurationTimeInMinutes);
        }
    }

    private void checkOutstandingOTPs(OtpHistory otpHistory, OtpHistoryKey otpHistoryKey, DateTime now) {
        OtpSettings otpSettings = this.otpSettings.get((Object)otpHistoryKey.getOperationType());
        int otpWindowSize = otpSettings.getOtpWindowSize();
        if (otpHistory.countOutstandingOTPs() >= otpWindowSize) {
            String identification = otpHistoryKey.getIdentification();
            int otpQuarantineTime = otpSettings.getOtpQuarantineTime();
            int otpWindowAge = otpSettings.getOtpWindowAge();
            this.sendFaultIndication(OtpLimitsFaultIndicationDescription.OTP_GENERATION_RATE_LIMIT_REACHED, otpHistory, identification);
            this.setQuarantineDate(identification, otpHistoryKey.getOperationType(), now.plusSeconds(otpQuarantineTime));
            long otpWindowAgeInMinutes = TimeUnit.SECONDS.toMinutes(otpWindowAge);
            throw new OtpLimitsException(OtpErrorCode.OTP_GENERATION_RATE_LIMIT_EXCEEDED, otpWindowAgeInMinutes);
        }
    }

    private String makeNewOtp(OtpEntity otpEntity, DateTime now) {
        OtpSettings otpSettings = this.otpSettings.get((Object)otpEntity.getOperationType());
        DateTime expires = now.plusMinutes(otpSettings.getOtpValidityMinutes());
        String otpString = otpSettings.createToken();
        byte[] salt = new byte[8];
        this.random.nextBytes(salt);
        byte[] otpHash = this.hashManager.getHmacHash(salt, otpString.getBytes());
        Otp otp = new Otp();
        otp.setExpiryDate(expires);
        otp.setIdentification(otpEntity.getIdentification());
        otp.setOperationType(otpEntity.getOperationType());
        otp.setOperation(otpEntity.getOperation());
        otp.setOtpHash(otpHash);
        otp.setSalt(salt);
        otp.setTries(otpSettings.getNumberOfTries());
        otp.setOtpTarget(otpEntity.getOtpTarget());
        otp.setGeneratedBy(otpEntity.getGeneratedBy());
        Otp existingOtp = this.otpDAO.find(otpEntity.getIdentification());
        if (existingOtp != null) {
            this.otpDAO.delete(otpEntity.getIdentification());
        }
        this.otpDAO.create(otp);
        if (otp.getGeneratedBy() != null && !otp.getGeneratedBy().isEmpty() && otpEntity.getGeneratedFor() != null) {
            otp.setIdentification(this.getIdentificationForGenericOTP(otpEntity.getGeneratedFor(), otp.getGeneratedBy()));
        }
        this.addOtpHistory(otp, now);
        return otpString;
    }

    private OtpHistory addOtpHistory(Otp otp, DateTime now) {
        OtpHistory otpHistory = this.lazyGetOtpHistory(otp);
        OtpSettings otpSettings = this.otpSettings.get((Object)otp.getOperationType());
        otpHistory = otpHistory.add(otp, otp.getOperationType(), now.plusSeconds(otpSettings.getOtpWindowAge()));
        this.updateRecentOtpHistory(OtpHistoryKey.fromOtp(otp), otpHistory);
        return otpHistory;
    }

    private OtpHistory lazyGetOtpHistory(Otp otp) {
        return this.getFromRecentOtpHistory(OtpHistoryKey.fromOtp(otp)).orElseGet(() -> this.createGeneralOtpHistory(otp));
    }

    private OtpHistory createGeneralOtpHistory(Otp otp) {
        OtpHistory otpHistory = new OtpHistory(OtpOperations.OTP_OPERATION_GENERAL);
        this.updateRecentOtpHistory(OtpHistoryKey.fromOtp(otp), otpHistory);
        return otpHistory;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public OtpService.OtpResult validateOtp(OtpEntity otpEntity, String otp) {
        DateTime now = new DateTime();
        return this.validateOtp(otpEntity, otp, now);
    }

    private OtpService.OtpResult validateOtp(OtpEntity otpEntity, String otpString, DateTime now) {
        OtpService.OtpResult result;
        if (otpEntity.getIdentification() == null || otpString == null) {
            return new OtpService.OtpResult(OtpService.OtpStatus.OTP_NOT_FOUND);
        }
        Otp otp = this.otpDAO.find(otpEntity.getIdentification());
        if (otp == null) {
            return new OtpService.OtpResult(OtpService.OtpStatus.OTP_NOT_FOUND);
        }
        if (now.isAfter(otp.getExpiryDate())) {
            this.otpDAO.delete(otpEntity.getIdentification());
            return new OtpService.OtpResult(OtpService.OtpStatus.OTP_NOT_FOUND);
        }
        if (otpEntity.getOperation() != null) {
            if (!otpEntity.getOperation().equals(otp.getOperation())) {
                this.otpDAO.delete(otpEntity.getIdentification());
                return new OtpService.OtpResult(OtpService.OtpStatus.OTP_NOT_FOUND);
            }
        } else if (otp.getOperation() != null) {
            this.otpDAO.delete(otpEntity.getIdentification());
            return new OtpService.OtpResult(OtpService.OtpStatus.OTP_NOT_FOUND);
        }
        if (otp.getGeneratedBy() != null && !otp.getGeneratedBy().isEmpty() && otpEntity.getGeneratedFor() != null) {
            if (!otp.getGeneratedBy().equals(otpEntity.getGeneratedBy())) {
                return new OtpService.OtpResult(OtpService.OtpStatus.OTP_NOT_FOUND);
            }
            otp.setIdentification(this.getIdentificationForGenericOTP(otpEntity.getGeneratedFor(), otp.getGeneratedBy()));
        }
        if (this.hashManager.validateHmacHash(otp.getSalt(), otpString.getBytes(), otp.getOtpHash())) {
            result = new OtpService.OtpResult(OtpService.OtpStatus.VALID, otp.getOtpTarget());
            this.markSuccessHistory(otp);
            this.otpDAO.delete(otpEntity.getIdentification());
        } else {
            OtpHistory otpHistory = this.addOtpHistory(otp, now);
            otpHistory = otpHistory.addFailedOTPAttempt(now);
            this.updateRecentOtpHistory(OtpHistoryKey.fromOtp(otp), otpHistory);
            result = new OtpService.OtpResult(OtpService.OtpStatus.INVALID_OTP);
            int triesLeft = otp.getTries() - 1;
            if (triesLeft <= 0) {
                this.otpDAO.delete(otpEntity.getIdentification());
                OtpServiceListener otpServiceListener = this.otpServiceListeners.get((Object)otp.getOperationType());
                if (otpServiceListener != null) {
                    otpServiceListener.onFailureLimitExceeded(otpEntity.getIdentification());
                }
            } else {
                otp.setTries(triesLeft);
                otp.setIdentification(otpEntity.getIdentification());
                this.otpDAO.update((Object)otp);
            }
        }
        return result;
    }

    private void markSuccessHistory(Otp otp) {
        OtpHistory otpHistory = this.lazyGetOtpHistory(otp);
        otpHistory = otpHistory.resetFailCounter();
        otpHistory = otpHistory.markCorrectlyUsedOtp(otp);
        this.updateRecentOtpHistory(OtpHistoryKey.fromOtp(otp), otpHistory);
    }

    @Override
    public void setOtpOperationGeneral(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_GENERAL, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationCredentialsReset(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_CREDENTIALS_RESET, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationCredentialsSelfPinReset(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_CREDENTIALS_SELF_PIN_RESET, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationEmailVerification(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_EMAIL_VERIFICATION, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationDefaultNotificationMsisdnVerification(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_DEFAULT_NOTIFICATION_MSISDN_VERIFICATION, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationDefaultNotificationEmailVerification(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_DEFAULT_NOTIFICATION_EMAIL_VERIFICATION, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationSelfServiceNotificationReceiverMsisdnVerification(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_SELFSERVICE_NOTIFICATION_RECEIVER_MSISDN_VERIFICATION, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationSelfServiceNotificationReceiverEmailVerification(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_SELFSERVICE_NOTIFICATION_RECEIVER_EMAIL_VERIFICATION, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationMsisdnVerification(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_MSISDN_VERIFICATION, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationBankAccountVerification(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_BANK_ACCOUNT_VERIFICATION, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationAtm(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_ATM, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationLogin(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_LOGIN, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationRedeemCashVoucher(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_REDEEM_CASHVOUCHER, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationCancelCashVoucher(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_CANCEL_CASHVOUCHER, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationReclaimCashVoucher(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_RECLAIM_CASHVOUCHER, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationCashIn(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_CASH_IN, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationResetCardPin(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_RESET_CARD_PIN, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationLinkFinancialResource(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_LINK_FINANCIAL_RESOURCE, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationCreateDeviceCredential(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_CREATE_DEVICE_CREDENTIAL, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationSetProfile(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_SET_PROFILE, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationUpdateIdentification(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_UPDATE_IDENTIFICATION, new OtpSettings(settings));
    }

    @Override
    public void setOtpSecurityQuestions(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_SECURITY_QUESTIONS, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationDownloadDocument(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_DOWNLOAD_DOCUMENT, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationVerifyAccountHolder(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_VERIFY_ACCOUNT_HOLDER, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationVerifyPointOfSaleMsisdn(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_VERIFY_POINT_OF_SALE_MSISDN, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationTransfer(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_TRANSFER, new OtpSettings(settings));
    }

    @Override
    public void setOtpOperationPayment(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_PAYMENT, new OtpSettings(settings));
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @ServiceProperty
    public void setPriority(String priority) {
        this.priority = priority.trim().isEmpty() ? null : Integer.valueOf(priority);
    }

    @ServiceProperty
    public void setClusterPort(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid value for ClusterPort: " + value);
        }
        this.clusterPort = value;
    }

    @Override
    public ErrorCode getErrorCodeFromValidationResult(OtpService.OtpStatus result) {
        return this.errorCodesFromValidationResults.get((Object)result);
    }

    @Override
    public void addFailedSecurityAnswerAttempt(String identification) {
        OtpHistoryKey otpHistoryKey = OtpHistoryKey.valueOf(identification, OtpOperations.OTP_SECURITY_QUESTIONS);
        OtpHistory otpHistory = this.getFromRecentOtpHistory(otpHistoryKey).orElseGet(() -> new OtpHistory(OtpOperations.OTP_SECURITY_QUESTIONS));
        otpHistory = otpHistory.addFailedOTPAttempt(new DateTime());
        this.updateRecentOtpHistory(otpHistoryKey, otpHistory);
    }

    @Override
    public void checkSecurityAnswerFailureLimits(String identification) {
        DateTime now = new DateTime();
        OtpHistoryKey otpHistoryKey = OtpHistoryKey.valueOf(identification, OtpOperations.OTP_SECURITY_QUESTIONS);
        Optional<OtpHistory> otpHistory = this.getFromRecentOtpHistory(otpHistoryKey);
        if (otpHistory.isPresent()) {
            this.checkIfInQuarantine(otpHistory.get(), otpHistoryKey, now);
            this.checkOtpFailureCounter(otpHistory.get(), otpHistoryKey, now);
        }
    }

    @Override
    public void resetSecurityAnswerFailCounter(String identification) {
        OtpHistoryKey otpHistoryKey = OtpHistoryKey.valueOf(identification, OtpOperations.OTP_SECURITY_QUESTIONS);
        Optional<OtpHistory> otpHistory = this.getFromRecentOtpHistory(otpHistoryKey);
        if (otpHistory.isPresent()) {
            this.updateRecentOtpHistory(otpHistoryKey, otpHistory.get().resetFailCounter());
        }
    }

    @Override
    public int getNumberOfSecurityQuestionsForReset() {
        return this.otpSettings.get((Object)OtpOperations.OTP_SECURITY_QUESTIONS) != null ? this.otpSettings.get((Object)OtpOperations.OTP_SECURITY_QUESTIONS).getNumberOfSecurityQuestionsForReset() : new OtpSettings().getNumberOfSecurityQuestionsForReset();
    }

    @Override
    public void registerListener(OtpOperations operationType, OtpServiceListener listener) {
        Preconditions.assertNotNull(listener);
        this.otpServiceListeners.putIfAbsent(operationType, listener);
    }

    @Override
    public String getIdentificationForGenericOTP(String generatedFor, String generatedBy) {
        return generatedFor + "::" + generatedBy;
    }

    @Override
    public List<NotificationChannelType> getAllowedNotificationChannelsForOtpOperation(OtpOperations operationType) {
        return this.otpSettings.get((Object)operationType).getAllowedNotificationChannels();
    }

    private Optional<OtpHistory> getFromRecentOtpHistory(OtpHistoryKey otpHistoryKey) {
        return this.getFromRecentOtpHistory(otpHistoryKey.toStringKey());
    }

    private Optional<OtpHistory> getFromRecentOtpHistory(String otpHistoryStringKey) {
        byte[] serializedDate = (byte[])this.recentOtpHistory.get(otpHistoryStringKey.toLowerCase());
        return Optional.ofNullable(this.deserializeOtpHistory(serializedDate));
    }

    private OtpHistory deserializeOtpHistory(byte[] serialized) {
        if (serialized == null) {
            return null;
        }
        try {
            return (OtpHistory)ByteArrayUtilities.byteArrayToObject(serialized);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Unexpected error class not found", e);
            throw new IllegalStateException();
        }
    }

    private void updateRecentOtpHistory(OtpHistoryKey otpHistoryKey, OtpHistory otpHistory) {
        this.updateRecentOtpHistory(otpHistoryKey.toStringKey(), otpHistory);
    }

    private void updateRecentOtpHistory(String otpHistoryStringKey, OtpHistory otpHistory) {
        if (otpHistory != null) {
            OtpHistory existingValue = this.deserializeOtpHistory((byte[])this.recentOtpHistory.get(otpHistoryStringKey.toLowerCase()));
            if (existingValue == null || !existingValue.equals(otpHistory)) {
                this.recentOtpHistory.put(otpHistoryStringKey.toLowerCase(), ByteArrayUtilities.objectToByteArray(otpHistory));
            }
        } else {
            this.recentOtpHistory.remove(otpHistoryStringKey.toLowerCase());
        }
    }

    @Override
    public void setOtpOperationTOTPReset(List<String> settings) {
        this.otpSettings.put(OtpOperations.OTP_OPERATION_RESET_TOTP, new OtpSettings(settings));
    }

    private class ExpiredOtpProcessor
    implements ResultSetProcessor {
        private ExpiredOtpProcessor() {
        }

        public void process(long id) {
            Otp otp = OtpServiceBean.this.otpDAO.find(id);
            if (otp != null) {
                String identification = otp.getIdentification();
                OtpHistory otpHistory = OtpServiceBean.this.lazyGetOtpHistory(otp);
                otpHistory = otpHistory.addFailedOTPAttempt(new DateTime());
                OtpServiceBean.this.updateRecentOtpHistory(OtpHistoryKey.fromOtp(otp), otpHistory);
                OtpServiceBean.this.otpDAO.delete(identification);
                OtpServiceListener otpServiceListener = OtpServiceBean.this.otpServiceListeners.get((Object)otp.getOperationType());
                if (otpServiceListener != null) {
                    otpServiceListener.onExpired(identification);
                }
            }
        }

        public TransacitonAwareProcessor.TransactionManagement getTransactionManagement() {
            return TransacitonAwareProcessor.TransactionManagement.CREATE_NEW_TRANSACTION;
        }
    }
}

