/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.otp;

import com.ericsson.em.emc.operations.otp.OtpOperations;
import com.ericsson.em.emc.otp.persistence.Otp;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

public class OtpHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<OtpGenerationInformation> issuedOTPs;
    private DateTime latestFail;
    private int recentFailures;
    private DateTime quarantineEndDate;
    private int totalFailures;
    private final OtpOperations otpOperation;

    public OtpHistory(OtpOperations otpOperation) {
        this.issuedOTPs = Collections.emptyList();
        this.otpOperation = otpOperation;
    }

    private OtpHistory(List<OtpGenerationInformation> issuedOtps, DateTime latestFail, int failedCounter, DateTime quarantineEndDate, int totalFailures, OtpOperations otpOperations) {
        this.issuedOTPs = new ArrayList<OtpGenerationInformation>(issuedOtps);
        this.latestFail = latestFail;
        this.quarantineEndDate = quarantineEndDate;
        this.recentFailures = failedCounter;
        this.totalFailures = totalFailures;
        this.otpOperation = otpOperations;
    }

    public OtpHistory addFailedOTPAttempt(DateTime failDate) {
        return new OtpHistory(this.issuedOTPs, failDate, this.recentFailures + 1, this.quarantineEndDate, this.totalFailures + 1, this.otpOperation);
    }

    public DateTime getQuaratineDate() {
        return this.quarantineEndDate;
    }

    public OtpHistory setQuarantineEndDate(DateTime quarantineEndDate) {
        return new OtpHistory(this.issuedOTPs, this.latestFail, this.recentFailures, quarantineEndDate, this.totalFailures, this.otpOperation);
    }

    public boolean isInQuarantine() {
        return this.quarantineEndDate != null;
    }

    public boolean isInQuarantineAt(DateTime now) {
        return this.quarantineEndDate != null && this.quarantineEndDate.isAfter(now);
    }

    public int getRecentFailureCount() {
        return this.recentFailures;
    }

    public int getTotalFailureCount() {
        return this.totalFailures;
    }

    public OtpHistory resetFailCounter() {
        return new OtpHistory(this.issuedOTPs, null, 0, this.quarantineEndDate, 0, this.otpOperation);
    }

    public DateTime getLatestFail() {
        return this.latestFail;
    }

    public OtpOperations getOtpOperation() {
        return this.otpOperation;
    }

    public OtpHistory add(Otp otp, OtpOperations otpOperations, DateTime expiryDate) {
        OtpGenerationInformation ogi = new OtpGenerationInformation(otp, expiryDate);
        ArrayList<OtpGenerationInformation> list = new ArrayList<OtpGenerationInformation>(this.issuedOTPs.size() + 1);
        list.addAll(this.issuedOTPs);
        list.add(ogi);
        return new OtpHistory(list, this.latestFail, this.recentFailures, this.quarantineEndDate, this.totalFailures, otpOperations);
    }

    public int countOutstandingOTPs() {
        return this.issuedOTPs.size();
    }

    public boolean isOTPGenerationAllowedByCounter(DateTime now, int timeToPass, int failCounterLimit) {
        if (this.recentFailures < failCounterLimit || this.latestFail == null) {
            return true;
        }
        return now.isAfter(new DateTime(this.latestFail.getMillis() + (long)timeToPass * 1000L));
    }

    public OtpHistory clearHistoryExpiredOTPs(DateTime now) {
        return this.clearHistoryExpiredOTPs(now, 0);
    }

    public OtpHistory clearHistoryExpiredOTPs(DateTime now, int delayInSeconds) {
        DateTime newQuarantineDate = this.quarantineEndDate;
        int recentFailures = this.recentFailures;
        if (this.quarantineEndDate != null && this.quarantineEndDate.isBefore(now) || this.quarantineEndDate == null && delayInSeconds != 0 && this.latestFail != null && this.latestFail.plusSeconds(delayInSeconds).isBefore(now)) {
            newQuarantineDate = null;
            recentFailures = 0;
        }
        List<OtpGenerationInformation> newIssuedOTPs = this.issuedOTPs.stream().filter(ogi -> ogi.getHistoryExpiryDate().isAfter(now)).collect(Collectors.toList());
        return new OtpHistory(newIssuedOTPs, this.latestFail, recentFailures, newQuarantineDate, this.totalFailures, this.otpOperation);
    }

    public OtpHistory markCorrectlyUsedOtp(Otp otp) {
        LinkedList<OtpGenerationInformation> otherIssuedOTPs = new LinkedList<OtpGenerationInformation>();
        for (OtpGenerationInformation ogi : this.issuedOTPs) {
            if (otp.equals((Object)ogi.getOtp())) continue;
            otherIssuedOTPs.add(ogi);
        }
        return new OtpHistory(otherIssuedOTPs, this.latestFail, this.recentFailures, this.quarantineEndDate, this.totalFailures, this.otpOperation);
    }

    public boolean isExpired(DateTime now) {
        return this.countOutstandingOTPs() == 0 && this.recentFailures == 0 && !this.isInQuarantineAt(now);
    }

    public static class OtpGenerationInformation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final DateTime expiryDate;
        private final Otp otp;

        public OtpGenerationInformation(Otp otp, DateTime expiryDate) {
            this.otp = otp;
            this.expiryDate = expiryDate;
        }

        public Otp getOtp() {
            return this.otp;
        }

        public DateTime getHistoryExpiryDate() {
            return this.expiryDate;
        }
    }
}

