/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.numbernormalization;

import com.ericsson.em.emc.numbernormalization.NumberNormalization;
import com.ericsson.em.emc.numbernormalization.NumberNormalizationErrorCode;
import com.ericsson.em.emc.numbernormalization.NumberNormalizationException;
import com.ericsson.lwac.deployer.service.Service;
import jakarta.annotation.PostConstruct;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Service
public class NumberNormalizationBean
implements NumberNormalization {
    private String countryCode = "";
    private String intPrefix = "";
    private String natPrefix = "";
    private boolean allowNational = false;
    private boolean fallbackToInternational = true;
    private int minDigits = 0;
    private List<String> countryCodes = new CopyOnWriteArrayList<String>();
    private static final String ISO_REGEXP = "^\\+[0-9]{1,3}-[0-9()+\\\\-]{1,30}$";
    private static final String MSISDN_DB_SAVE_REGEXP = "^[1-9][0-9]{0,31}$";

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setInternationalPrefix(String intPrefix) {
        this.intPrefix = intPrefix;
    }

    public void setNationalPrefix(String natPrefix) {
        this.natPrefix = natPrefix;
    }

    public void setAllowNationalNumbers(boolean allowNational) {
        this.allowNational = allowNational;
    }

    public void setMinimumNumberOfDigits(int minDigits) {
        this.minDigits = minDigits;
    }

    public void setFallbackToInternational(boolean fallbackToInternational) {
        this.fallbackToInternational = fallbackToInternational;
    }

    @Override
    public String normalize(String msisdn, int ton, int npi) {
        this.checkMSISDNBeforeFormat(msisdn);
        if (npi != 1) {
            throw new NumberNormalizationException(NumberNormalizationErrorCode.NUMBERNORMALIZATION_INVALID_NPI, msisdn, npi);
        }
        if (ton == 1) {
            return this.format("", msisdn, msisdn);
        }
        if (ton == 2) {
            return this.format(this.countryCode, msisdn, msisdn);
        }
        throw new NumberNormalizationException(NumberNormalizationErrorCode.NUMBERNORMALIZATION_INVALID_TON, msisdn, ton);
    }

    @Override
    public String normalize(String msisdn) {
        this.checkMSISDNBeforeFormat(msisdn);
        if (msisdn.startsWith("+")) {
            return this.format("", msisdn.substring(1), msisdn);
        }
        if (msisdn.startsWith(this.intPrefix)) {
            return this.format("", msisdn.substring(this.intPrefix.length()), msisdn);
        }
        if (this.allowNational && msisdn.startsWith(this.natPrefix)) {
            return this.format(this.countryCode, msisdn.substring(this.natPrefix.length()), msisdn);
        }
        if (!this.allowNational && msisdn.startsWith(this.natPrefix)) {
            throw new NumberNormalizationException(NumberNormalizationErrorCode.NUMBERNORMALIZATION_INVALID_MSISDN, msisdn);
        }
        if (this.fallbackToInternational) {
            return this.format("", msisdn, msisdn);
        }
        throw new NumberNormalizationException(NumberNormalizationErrorCode.NUMBERNORMALIZATION_INVALID_MSISDN, msisdn);
    }

    private void checkMSISDNBeforeFormat(String msisdn) {
        if (msisdn == null) {
            throw new NumberNormalizationException(NumberNormalizationErrorCode.NUMBERNORMALIZATION_INVALID_MSISDN, "null");
        }
    }

    private String format(String countryCodeToAdd, String msisdn, String originalMsisdn) {
        String rv;
        msisdn = msisdn.replace("-", "");
        if (!this.isValidMSISDN(countryCodeToAdd, msisdn = msisdn.replace(" ", ""))) {
            throw new NumberNormalizationException(NumberNormalizationErrorCode.NUMBERNORMALIZATION_INVALID_MSISDN, originalMsisdn);
        }
        if (!countryCodeToAdd.isEmpty() && !this.countryCodes.contains(countryCodeToAdd)) {
            throw new NumberNormalizationException(NumberNormalizationErrorCode.NUMBERNORMALIZATION_INVALID_MSISDN, originalMsisdn);
        }
        if (countryCodeToAdd.isEmpty()) {
            boolean found = false;
            for (String cc : this.countryCodes) {
                if (cc.isEmpty() || !msisdn.startsWith(cc)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new NumberNormalizationException(NumberNormalizationErrorCode.NUMBERNORMALIZATION_INVALID_MSISDN, originalMsisdn);
            }
        }
        if (!(rv = countryCodeToAdd + msisdn).matches(MSISDN_DB_SAVE_REGEXP)) {
            throw new NumberNormalizationException(NumberNormalizationErrorCode.NUMBERNORMALIZATION_INVALID_MSISDN, rv);
        }
        return rv;
    }

    @Override
    public boolean isValidMSISDN(String msisdn) {
        if (msisdn == null) {
            return false;
        }
        msisdn = msisdn.replace("-", "");
        if ((msisdn = msisdn.replace(" ", "")).startsWith("+")) {
            return this.isValidMSISDN("", msisdn.substring(1));
        }
        if (msisdn.startsWith(this.intPrefix)) {
            return this.isValidMSISDN("", msisdn.substring(this.intPrefix.length()));
        }
        if (this.allowNational && msisdn.startsWith(this.natPrefix)) {
            return this.isValidMSISDN(this.countryCode, msisdn.substring(this.natPrefix.length()));
        }
        if (!this.allowNational && msisdn.startsWith(this.natPrefix)) {
            return false;
        }
        if (this.fallbackToInternational) {
            return this.isValidMSISDN("", msisdn);
        }
        return false;
    }

    private boolean isValidMSISDN(String countryCodeToAdd, String msisdn) {
        String rv = countryCodeToAdd + msisdn;
        if (rv.length() < this.minDigits) {
            return false;
        }
        if (!rv.matches(MSISDN_DB_SAVE_REGEXP)) {
            return false;
        }
        if (!countryCodeToAdd.isEmpty() && !this.countryCodes.contains(countryCodeToAdd)) {
            return false;
        }
        if (countryCodeToAdd.isEmpty()) {
            boolean found = false;
            for (String cc : this.countryCodes) {
                if (cc.isEmpty() || !msisdn.startsWith(cc)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    @PostConstruct
    public void postConstruct() throws IOException {
        InputStreamReader reader;
        LinkedList<Integer> countryCodes = new LinkedList<Integer>();
        try {
            reader = new FileReader("etc/country-codes.lst");
        }
        catch (FileNotFoundException e) {
            reader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("country-codes.lst"));
        }
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || !line.matches("\\d+")) continue;
                countryCodes.add(Integer.parseInt(line));
            }
        }
        Collections.sort(countryCodes);
        Collections.reverse(countryCodes);
        this.countryCodes = new CopyOnWriteArrayList<String>();
        for (Integer code : countryCodes) {
            this.countryCodes.add("" + code);
        }
    }

    @Override
    public String toISOStandard(String number) {
        if (number == null) {
            return null;
        }
        number = number.trim();
        while (number.startsWith("+")) {
            number = number.substring(1);
        }
        for (String countryCode : this.countryCodes) {
            if (!number.startsWith(countryCode)) continue;
            String msisdnWithoutCountry = number.substring(countryCode.length());
            while (msisdnWithoutCountry.startsWith("-")) {
                msisdnWithoutCountry = msisdnWithoutCountry.substring(1);
            }
            number = String.format("+%s-%s", countryCode, msisdnWithoutCountry);
            break;
        }
        if (number.matches(ISO_REGEXP)) {
            return number;
        }
        throw new NumberNormalizationException(NumberNormalizationErrorCode.NUMBERNORMALIZATION_INVALID_NUMBER, number);
    }
}

