/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.threshold;

import com.ericsson.em.emc.hierarchies.limits.LimitMatchingParameters;
import com.ericsson.em.emc.hierarchies.limits.ThresholdMatcher;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.em.emc.hierarchies.persistence.ThresholdConfiguration;
import com.ericsson.em.emc.hierarchies.threshold.DynamicThresholdsRetriever;
import com.ericsson.em.emc.hierarchies.threshold.Threshold;
import com.ericsson.em.emc.hierarchies.threshold.ThresholdResponse;
import com.ericsson.em.emc.hierarchies.threshold.ThresholdService;
import jakarta.ejb.Singleton;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

@Singleton
public class ThresholdServiceBean
implements ThresholdService {
    private final Map<Long, Threshold> thresholds = new ConcurrentHashMap<Long, Threshold>();

    @Override
    public List<ThresholdResponse> executeThresholds(String externalId, ProfileReference profileReference, ProfileService profileService, LimitMatchingParameters matchingParameters, BigDecimal amount, DateTime dateTime, Optional<DynamicThresholdsRetriever> dynamicThresholdsRetriever) {
        Objects.requireNonNull(matchingParameters.getUnit());
        LinkedList<ThresholdResponse> thresholdResponses = new LinkedList<ThresholdResponse>();
        List<ThresholdConfiguration> matchingConfigurations = ThresholdServiceBean.getMatchingConfigurations(profileService, matchingParameters, dateTime);
        for (ThresholdConfiguration thresholdConfiguration : matchingConfigurations) {
            thresholdResponses.addAll(this.executeThreshold(externalId, thresholdConfiguration, profileReference, amount, dynamicThresholdsRetriever));
        }
        return thresholdResponses;
    }

    private static List<ThresholdConfiguration> getMatchingConfigurations(ProfileService profileService, LimitMatchingParameters matchingParameters, DateTime dateTime) {
        List<ThresholdConfiguration> allConfigurations = profileService.getThresholdConfigurations();
        return allConfigurations.stream().filter(conf -> ThresholdMatcher.isMatching(conf, matchingParameters, dateTime)).collect(Collectors.toList());
    }

    private List<ThresholdResponse> executeThreshold(String externalId, ThresholdConfiguration thresholdConfiguration, ProfileReference profileReference, BigDecimal value, Optional<DynamicThresholdsRetriever> dynamicThresholdsRetriever) {
        LinkedList<ThresholdResponse> responses = new LinkedList<ThresholdResponse>();
        this.executeBuiltInThreshold(externalId, thresholdConfiguration, profileReference, value, responses);
        this.executeDynamicThresholds(externalId, thresholdConfiguration, profileReference, value, dynamicThresholdsRetriever, responses);
        return responses;
    }

    private void executeDynamicThresholds(String externalId, ThresholdConfiguration thresholdConfiguration, ProfileReference profileReference, BigDecimal value, Optional<DynamicThresholdsRetriever> dynamicThresholdsRetriever, List<ThresholdResponse> responses) {
        List<Threshold> dynamicThresholds;
        if (dynamicThresholdsRetriever.isPresent() && (dynamicThresholds = dynamicThresholdsRetriever.get().get(thresholdConfiguration, profileReference)) != null) {
            for (Threshold threshold : dynamicThresholds) {
                ThresholdResponse response = threshold.execute(externalId, thresholdConfiguration, profileReference, value);
                response.setThresholdConfiguration(thresholdConfiguration);
                response.setThreshold(threshold);
                responses.add(response);
            }
        }
    }

    private void executeBuiltInThreshold(String externalId, ThresholdConfiguration thresholdConfiguration, ProfileReference profileReference, BigDecimal value, List<ThresholdResponse> responses) {
        if (thresholdConfiguration.getClassName() == null) {
            return;
        }
        Threshold threshold = this.thresholds.get(thresholdConfiguration.getId());
        if (threshold != null && !threshold.getClass().getName().equals(thresholdConfiguration.getClassName())) {
            this.thresholds.remove(thresholdConfiguration.getId());
            threshold = null;
        }
        if (threshold == null) {
            try {
                threshold = (Threshold)ClassLoader.getSystemClassLoader().loadClass(thresholdConfiguration.getClassName()).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Error while loading Threshold: %s", thresholdConfiguration.getClassName()), e);
            }
            this.thresholds.put(thresholdConfiguration.getId(), threshold);
        }
        ThresholdResponse response = threshold.execute(externalId, thresholdConfiguration, profileReference, value);
        response.setThresholdConfiguration(thresholdConfiguration);
        response.setThreshold(threshold);
        responses.add(response);
    }
}

