/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.PersonalModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.PersonalModifierConfigurationDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;

@Validatable
@Singleton
@Updatable
@CryptoKeys(keyAliases={"hier.personalmodifierconf.S"})
public class PersonalModifierConfigurationDAOBean
extends CryptoExtendedBaseEntityDAOBean<PersonalModifierConfiguration>
implements PersonalModifierConfigurationDAO {
    static final String FINGERPRINT_KEY = "hier.personalmodifierconf.S";
    private static final int DEFAULT_FINGERPRINT_VERSION = 1;
    private static final int CURRENT_FINGERPRINT_VERSION = 1;
    private static final String TABLE_NAME = "hier$personalmodifierconf";
    private static final String TABLE_SEQUENCE_NAME = "hier$personalmodifierconf_seq";

    @Override
    public PersonalModifierConfiguration find(Long id) {
        return (PersonalModifierConfiguration)super.find(id.longValue());
    }

    @Override
    public PersonalModifierConfiguration find(CounterConfiguration counterConfiguration, ProfileReference profileReference) {
        return (PersonalModifierConfiguration)this.find(this.getSelectStatement() + " where " + TableColumn.FK_COUNTERCONFIGURATION.name() + " = ? and " + String.valueOf((Object)TableColumn.FK_PROFILEREFERENCE) + " = ?", new Object[]{counterConfiguration.getId(), profileReference.getProfileReferenceId()});
    }

    @Override
    public PersonalModifierConfiguration create(PersonalModifierConfiguration personalModifierConfiguration) {
        return (PersonalModifierConfiguration)super.create((BaseEntity)personalModifierConfiguration);
    }

    @Override
    public PersonalModifierConfiguration update(PersonalModifierConfiguration personalModifierConfiguration) {
        return (PersonalModifierConfiguration)super.update((BaseEntity)personalModifierConfiguration);
    }

    protected PersonalModifierConfiguration createManagedEntity() {
        return new PersonalModifierConfiguration();
    }

    @Override
    public void delete(PersonalModifierConfiguration personalModifierConfiguration) {
        super.delete((BaseEntity)personalModifierConfiguration);
    }

    @Override
    public void deleteByCounterConfiguration(CounterConfiguration counterConfiguration) {
        super.delete("delete from hier$personalmodifierconf where + " + TableColumn.FK_COUNTERCONFIGURATION.name() + " = ?", new Object[]{counterConfiguration.getId()});
    }

    protected String getEntitySimpleName() {
        return PersonalModifierConfiguration.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 1;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1) {
            return new Object[]{resultSet.getLong(TableColumn.FK_COUNTERCONFIGURATION.name()), resultSet.getLong(TableColumn.FK_PROFILEREFERENCE.name()), resultSet.getBigDecimal(TableColumn.STARTVALUE.name()), resultSet.getBigDecimal(TableColumn.ENDVALUE.name()), resultSet.getString(TableColumn.CLASSNAME.name()), resultSet.getString(TableColumn.DATA.name()), resultSet.getString(TableColumn.NAME.name())};
        }
        return null;
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return TABLE_SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return false;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        PersonalModifierConfiguration personalModifierConfiguration = (PersonalModifierConfiguration)baseEntity;
        int i = 1;
        preparedStatement.setLong(i++, personalModifierConfiguration.getCounterConfiguration().getId());
        preparedStatement.setLong(i++, personalModifierConfiguration.getProfileReference().getProfileReferenceId());
        preparedStatement.setBigDecimal(i++, personalModifierConfiguration.getStartValue());
        preparedStatement.setBigDecimal(i++, personalModifierConfiguration.getEndValue());
        preparedStatement.setString(i++, personalModifierConfiguration.getClassName());
        preparedStatement.setString(i++, personalModifierConfiguration.getData());
        preparedStatement.setString(i++, personalModifierConfiguration.getName());
        return this.assignFingerprint(preparedStatement, i, new Object[]{personalModifierConfiguration.getCounterConfiguration().getId(), personalModifierConfiguration.getProfileReference().getProfileReferenceId(), personalModifierConfiguration.getStartValue(), personalModifierConfiguration.getEndValue(), personalModifierConfiguration.getClassName(), personalModifierConfiguration.getData(), personalModifierConfiguration.getName()});
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        PersonalModifierConfiguration personalModifierConfiguration = (PersonalModifierConfiguration)baseEntity;
        personalModifierConfiguration.setClassName(resultSet.getString("classname"));
        personalModifierConfiguration.setStartValue(resultSet.getBigDecimal("startvalue"));
        personalModifierConfiguration.setEndValue(resultSet.getBigDecimal("endvalue"));
        personalModifierConfiguration.setData(resultSet.getString("data"));
        personalModifierConfiguration.setName(resultSet.getString("name"));
        personalModifierConfiguration.setCounterConfigurationId(resultSet.getLong("fk_counterconfiguration"));
        personalModifierConfiguration.setProfileReferenceId(resultSet.getLong("fk_profilereference"));
    }

    private static enum TableColumn {
        ID,
        FK_COUNTERCONFIGURATION,
        FK_PROFILEREFERENCE,
        STARTVALUE,
        ENDVALUE,
        CLASSNAME,
        DATA,
        NAME,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION;


        int index() {
            return this.ordinal();
        }
    }
}

