/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.PeriodManager;
import com.ericsson.em.emc.hierarchies.limits.RatingCounterType;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalance;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalanceDAO;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalanceReservation;
import com.ericsson.em.emc.hierarchies.persistence.CounterBalanceReservationDAO;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.NullCounterBalance;
import com.ericsson.em.emc.hierarchies.persistence.Period;
import com.ericsson.em.emc.hierarchies.persistence.PeriodDAOBean;
import com.ericsson.em.emc.hierarchies.persistence.Periodizable;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.lwac.cache.Cache;
import com.ericsson.lwac.cache.CacheService;
import com.ericsson.lwac.cli.ApplicationProperties;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.FingerprintUpdateResultSetProcessor;
import com.ericsson.lwac.crypto.securitymodule.persistence.Updatable;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import com.ericsson.lwac.database.persistence.EntityResultSetProcessor;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.Months;

@Updatable
@Validatable
@Singleton
@CryptoKeys(keyAliases={"hier.counterbalance.S"})
public class CounterBalanceDAOBean
extends PeriodDAOBean<CounterBalance>
implements CounterBalanceDAO {
    private static final CounterBalance NULL_CACHE = new NullCounterBalance();
    private Cache<String, CounterBalance> cache;
    @Resource
    private ApplicationProperties applicationProperties;
    @Resource
    private CacheService cacheService;
    private static final int CURRENT_FINGERPRINT_VERSION = 3;
    static final String FINGERPRINT_KEY = "hier.counterbalance.S";
    private static final String TABLE_NAME = "hier$counterbalance";
    private static final String TABLE_SEQUENCE_NAME = "hier$counterbalance_seq";
    @EJB
    private PeriodManager periodManager;
    @EJB
    private CounterBalanceReservationDAO counterBalanceReservationDAO;

    @PostConstruct
    public void postConstruct() {
        this.cache = this.cacheService.createCache(String.class, CounterBalance.class, true);
    }

    @Override
    public int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        CounterBalance counterBalance = (CounterBalance)baseEntity;
        super.assign((BaseEntity)counterBalance, preparedStatement);
        preparedStatement.setLong(TableColumn.FK_COUNTERCONFIGURATION.index(), counterBalance.getCounterConfigurationId());
        preparedStatement.setLong(TableColumn.FK_PROFILEREFERENCE.index(), counterBalance.getReferenceId());
        preparedStatement.setBigDecimal(TableColumn.TOTALBALANCE.index(), counterBalance.getTotalBalance());
        preparedStatement.setBigDecimal(TableColumn.COMMITTEDBALANCE.index(), counterBalance.getCommittedBalance());
        preparedStatement.setBigDecimal(TableColumn.TOTALDISCOUNT.index(), counterBalance.getTotalDiscount());
        if (counterBalance.getInitTimestamp() != null) {
            preparedStatement.setObject(TableColumn.INITTIMESTAMP.index(), (Object)CounterBalanceDAOBean.getTimestamp((DateTime)counterBalance.getInitTimestamp()), 93, 9);
        } else {
            preparedStatement.setNull(TableColumn.INITTIMESTAMP.index(), 93);
        }
        preparedStatement.setLong(TableColumn.COUNTERTYPE.index(), counterBalance.getCounterType());
        preparedStatement.setObject(TableColumn.OBSOLETEDATE.index(), (Object)CounterBalanceDAOBean.getTimestamp((DateTime)counterBalance.getObsoleteDate()), 93, 9);
        preparedStatement.setBoolean(TableColumn.LIMITPERSONALIZED.index(), counterBalance.isLimitPersonalized());
        this.assignFingerprint(preparedStatement, TableColumn.FINGERPRINT.index(), new Object[]{null != counterBalance.getStartDateTime() ? CounterBalanceDAOBean.getTimestamp((DateTime)counterBalance.getStartDateTime()) : null, null != counterBalance.getEndDateTime() ? CounterBalanceDAOBean.getTimestamp((DateTime)counterBalance.getEndDateTime()) : null, counterBalance.getCounterConfigurationId(), counterBalance.getReferenceId(), counterBalance.getTotalBalance(), counterBalance.getCommittedBalance(), counterBalance.getTotalDiscount(), CounterBalanceDAOBean.getTimestamp((DateTime)counterBalance.getInitTimestamp()), counterBalance.getCounterType(), CounterBalanceDAOBean.getTimestamp((DateTime)counterBalance.getObsoleteDate()), counterBalance.isLimitPersonalized()});
        return TableColumn.VERSION.index();
    }

    @Override
    public CounterBalance update(CounterBalance counterBalance) {
        String key = this.generateCacheKey(counterBalance);
        counterBalance.setObsoleteDate(this.calculateUpdatedObsoleteDate(counterBalance.getObsoleteDate(), counterBalance.getEndDateTime()));
        this.cache.update(key, counterBalance);
        return (CounterBalance)super.updateWithVersionCheck((BaseEntity)counterBalance);
    }

    private String generateCacheKey(CounterBalance counterBalance) {
        return this.generateCacheKey(counterBalance.getCounterConfigurationId(), counterBalance.getReferenceId(), counterBalance.getCounterType());
    }

    private String generateCacheKey(long counterConfigurationId, long referenceId, long counterType) {
        return String.format("%d_%d_%d", counterConfigurationId, referenceId, counterType);
    }

    @Override
    public CounterBalance updateBalance(CounterBalance balance) {
        super.updateWithVersionCheck((BaseEntity)balance);
        this.cache.update(this.generateCacheKey(balance), balance);
        return balance;
    }

    public CounterBalance updateDefaultFingerprint(CounterBalance entry) {
        return (CounterBalance)this.updateWithVersionAndFingerprintVersionCheck(entry, 1);
    }

    public long updateDefaultFingerprintUsingResultSetProcessor(long batchSize, FingerprintUpdateResultSetProcessor fpResultSetProcessor) {
        if (this.isDefaultData()) {
            return 0L;
        }
        return this.processEntityResultSet("select * from (" + this.getSelectStatement() + " where " + String.valueOf((Object)TableColumn.FINGERPRINTVERSION) + "= ? order by " + String.valueOf((Object)TableColumn.ID) + ") WHERE rownum <= ?", (EntityResultSetProcessor)fpResultSetProcessor, new Object[]{1, batchSize});
    }

    @Override
    public CounterBalance updateBalanceProfileAndConfigurationReference(CounterBalance balance, ProfileReference newProfileReference, CounterConfiguration cc) {
        this.cache.remove(this.generateCacheKey(balance));
        if (cc.getCounterConfigurationType() == CounterConfiguration.CounterConfigurationType.INDIVIDUAL) {
            balance.setReferenceId(newProfileReference.getProfileReferenceId());
            balance.setCounterType(0L);
        } else {
            balance.setReferenceId(newProfileReference.getAccountHolderEUIId());
            balance.setCounterType(1L);
        }
        balance.setCounterConfigurationId(cc.getId());
        this.update(balance);
        return balance;
    }

    @Override
    public void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        CounterBalance counterBalance = (CounterBalance)baseEntity;
        counterBalance.setCounterConfigurationId(resultSet.getLong(TableColumn.FK_COUNTERCONFIGURATION.name()));
        counterBalance.setReferenceId(resultSet.getLong(TableColumn.FK_PROFILEREFERENCE.name()));
        counterBalance.setTotalBalance(resultSet.getBigDecimal(TableColumn.TOTALBALANCE.name()));
        counterBalance.setCommittedBalance(resultSet.getBigDecimal(TableColumn.COMMITTEDBALANCE.name()));
        counterBalance.setTotalDiscount(resultSet.getBigDecimal(TableColumn.TOTALDISCOUNT.name()));
        Timestamp initTime = resultSet.getTimestamp(TableColumn.INITTIMESTAMP.name());
        counterBalance.setInitTimestamp(initTime == null ? null : new DateTime(initTime.getTime()));
        counterBalance.setCounterType(resultSet.getLong(TableColumn.COUNTERTYPE.name()));
        Timestamp obsoleteDate = resultSet.getTimestamp(TableColumn.OBSOLETEDATE.name());
        counterBalance.setObsoleteDate(new DateTime(obsoleteDate.getTime()));
        counterBalance.setVersion(resultSet.getLong(TableColumn.VERSION.name()));
        counterBalance.setLimitPersonalized(resultSet.getBoolean(TableColumn.LIMITPERSONALIZED.name()));
    }

    public CounterBalance createManagedEntity() {
        return new CounterBalance();
    }

    @Override
    public CounterBalance create(CounterBalance counterBalance, CounterConfiguration counterConfiguration, ProfileReference profileReference) {
        return this.create(counterBalance, counterConfiguration, profileReference, false);
    }

    @Override
    public CounterBalance create(CounterBalance counterBalance, CounterConfiguration counterConfiguration, ProfileReference profileReference, boolean limitPersonalized) {
        if (counterConfiguration.getCounterConfigurationType() == CounterConfiguration.CounterConfigurationType.INDIVIDUAL) {
            counterBalance.setReferenceId(profileReference.getProfileReferenceId());
            counterBalance.setCounterType(0L);
        } else {
            counterBalance.setReferenceId(profileReference.getAccountHolderEUIId());
            counterBalance.setCounterType(1L);
        }
        counterBalance.setCounterConfigurationId(counterConfiguration.getId());
        BigDecimal defaultValue = counterConfiguration.getDefaultValue();
        counterBalance.setTotalBalance(defaultValue != null ? defaultValue : BigDecimal.ZERO);
        counterBalance.setCommittedBalance(defaultValue != null ? defaultValue : BigDecimal.ZERO);
        counterBalance.setTotalDiscount(BigDecimal.ZERO);
        counterBalance.setInitTimestamp(counterBalance.getInitTimestamp());
        counterBalance.setObsoleteDate(this.calculateObsoleteDate(counterBalance.getEndDateTime()));
        counterBalance.setLimitPersonalized(limitPersonalized);
        CounterBalance returnValue = (CounterBalance)super.create((BaseEntity)counterBalance);
        this.cache.update(this.generateCacheKey(counterBalance), counterBalance);
        return returnValue;
    }

    @Override
    public CounterBalance create(CounterBalance counterBalance) {
        counterBalance.setObsoleteDate(this.calculateObsoleteDate(counterBalance.getEndDateTime()));
        CounterBalance returnValue = (CounterBalance)super.create((BaseEntity)counterBalance);
        this.cache.update(this.generateCacheKey(counterBalance), counterBalance);
        return returnValue;
    }

    @Override
    public CounterBalance findCounterBalance(CounterConfiguration counterConfiguration, ProfileReference profileReference, DateTime dateTime) {
        Timestamp sqlTimestamp = CounterBalanceDAOBean.getTimestamp((DateTime)dateTime);
        Long referenceKey = counterConfiguration.getCounterConfigurationType() == CounterConfiguration.CounterConfigurationType.INDIVIDUAL ? profileReference.getProfileReferenceId() : profileReference.getAccountHolderEUIId().longValue();
        CounterBalance result = this.cache.getByPrimaryId(this.generateCacheKey(counterConfiguration.getId(), referenceKey, this.getCounterType(counterConfiguration)));
        if (result == NULL_CACHE) {
            return null;
        }
        if (result == null || this.isBefore(dateTime, result.getEndDateTime()) || this.isAfter(dateTime, result.getStartDateTime())) {
            if (result != null) {
                this.cache.remove(this.generateCacheKey(result));
            }
            if (counterConfiguration.isBalanceReuseable() && counterConfiguration.getPeriodType() != Periodizable.PeriodType.NO_PERIOD) {
                result = this.findLatestReusableBalance(counterConfiguration, referenceKey);
                if (result != null) {
                    DateTime startDateTime = result.getStartDateTime();
                    DateTime endDateTime = result.getEndDateTime();
                    if (startDateTime == null || endDateTime == null) {
                        this.periodManager.calculatePeriod(counterConfiguration, result, dateTime, startDateTime, null);
                        this.update(result);
                        this.expireReservations(result);
                    } else if (startDateTime.compareTo(dateTime) > 0 || dateTime.compareTo(endDateTime) >= 0) {
                        if (startDateTime.compareTo(dateTime) < 0) {
                            this.createNewReusablePeriod(counterConfiguration, dateTime, result);
                        } else {
                            result = null;
                        }
                    }
                }
            } else {
                result = this.findMatchingCounterBalance(counterConfiguration, referenceKey, sqlTimestamp);
            }
        }
        if (result != null) {
            this.cache.update(this.generateCacheKey(result.getCounterConfigurationId(), result.getReferenceId(), result.getCounterType()), result);
        } else {
            this.cacheNullRatingCounter(counterConfiguration, referenceKey);
        }
        return result;
    }

    @Override
    public List<CounterBalance> findByCounterConfigurations(List<? extends CounterConfiguration> counterConfigurations, ProfileReference profileReference, DateTime dateTime) {
        ArrayList<CounterBalance> results = new ArrayList<CounterBalance>();
        List ccIds = counterConfigurations.stream().map(BaseEntity::getId).collect(Collectors.toList());
        List<CounterBalance> counterBalances = new ArrayList<CounterBalance>();
        if (!this.checkIfAllBalancesFoundInCache(counterConfigurations, profileReference, counterBalances)) {
            boolean containsSharedCounters = counterConfigurations.stream().anyMatch(cc -> cc.getCounterConfigurationType().equals((Object)CounterConfiguration.CounterConfigurationType.SHARED));
            if (containsSharedCounters) {
                counterBalances.addAll(this.findByProfileReferenceId(profileReference.getAccountHolderEUIId()));
            }
            counterBalances.addAll(this.findByProfileReferenceId(profileReference.getProfileReferenceId()));
        }
        counterBalances = counterBalances.stream().filter(cb -> cb != NULL_CACHE).filter(cb -> ccIds.contains(cb.getCounterConfigurationId())).collect(Collectors.toList());
        Map<Long, List<CounterBalance>> counterBalanceByCCId = counterBalances.stream().collect(Collectors.groupingBy(CounterBalance::getCounterConfigurationId, Collectors.mapping(Function.identity(), Collectors.toList())));
        for (CounterConfiguration counterConfiguration : counterConfigurations) {
            Optional<CounterBalance> counterBalance = this.updateBalance(counterConfiguration, profileReference, dateTime, counterBalanceByCCId);
            counterBalance.ifPresent(results::add);
        }
        return results;
    }

    private boolean checkIfAllBalancesFoundInCache(List<? extends CounterConfiguration> counterConfigurations, ProfileReference profileReference, List<CounterBalance> results) {
        for (CounterConfiguration counterConfiguration : counterConfigurations) {
            long referenceKey = counterConfiguration.getCounterConfigurationType() == CounterConfiguration.CounterConfigurationType.INDIVIDUAL ? profileReference.getProfileReferenceId() : profileReference.getAccountHolderEUIId().longValue();
            CounterBalance result = this.cache.getByPrimaryId(this.generateCacheKey(counterConfiguration.getId(), referenceKey, this.getCounterType(counterConfiguration)));
            if (result != null) {
                results.add(result);
                continue;
            }
            return false;
        }
        return true;
    }

    private Optional<CounterBalance> updateBalance(CounterConfiguration counterConfiguration, ProfileReference profileReference, DateTime dateTime, Map<Long, List<CounterBalance>> counterBalanceByCCId) {
        Long referenceKey = counterConfiguration.getCounterConfigurationType() == CounterConfiguration.CounterConfigurationType.INDIVIDUAL ? profileReference.getProfileReferenceId() : profileReference.getAccountHolderEUIId().longValue();
        CounterBalance result = this.cache.getByPrimaryId(this.generateCacheKey(counterConfiguration.getId(), referenceKey, this.getCounterType(counterConfiguration)));
        if (result == NULL_CACHE) {
            return Optional.empty();
        }
        if (result == null || this.isBefore(dateTime, result.getEndDateTime()) || this.isAfter(dateTime, result.getStartDateTime())) {
            if (result != null) {
                this.cache.remove(this.generateCacheKey(result));
            }
            if (counterConfiguration.isBalanceReuseable() && counterConfiguration.getPeriodType() != Periodizable.PeriodType.NO_PERIOD) {
                Optional<Object> latestBalance = Optional.empty();
                if (counterBalanceByCCId.containsKey(counterConfiguration.getId())) {
                    latestBalance = counterBalanceByCCId.get(counterConfiguration.getId()).stream().filter(cb -> cb.getCounterType() == this.getCounterType(counterConfiguration)).max(Comparator.comparing(Period::getStartDateTime));
                }
                if (latestBalance.isPresent()) {
                    result = (CounterBalance)latestBalance.get();
                    DateTime startDateTime = result.getStartDateTime();
                    DateTime endDateTime = result.getEndDateTime();
                    if (startDateTime == null || endDateTime == null) {
                        this.periodManager.calculatePeriod(counterConfiguration, result, dateTime, startDateTime, null);
                        this.update(result);
                        this.expireReservations(result);
                    } else if (startDateTime.compareTo(dateTime) > 0 || dateTime.compareTo(endDateTime) >= 0) {
                        if (startDateTime.compareTo(dateTime) < 0) {
                            this.createNewReusablePeriod(counterConfiguration, dateTime, result);
                        } else {
                            result = null;
                        }
                    }
                }
            } else {
                Optional<Object> matchingBalance = Optional.empty();
                if (counterBalanceByCCId.containsKey(counterConfiguration.getId())) {
                    matchingBalance = counterBalanceByCCId.get(counterConfiguration.getId()).stream().filter(cb -> cb.getStartDateTime() == null || cb.getStartDateTime().isBefore(dateTime)).filter(cb -> cb.getEndDateTime() == null || cb.getEndDateTime().isAfter(dateTime)).filter(cb -> cb.getCounterType() == this.getCounterType(counterConfiguration)).findFirst();
                }
                if (matchingBalance.isPresent()) {
                    result = (CounterBalance)matchingBalance.get();
                }
            }
        }
        if (result != null) {
            this.cache.update(this.generateCacheKey(result.getCounterConfigurationId(), result.getReferenceId(), result.getCounterType()), result);
        } else {
            this.cacheNullRatingCounter(counterConfiguration, referenceKey);
        }
        return Optional.ofNullable(result);
    }

    private List<CounterBalance> findByProfileReferenceId(long id) {
        return this.findMultiple(this.getSelectStatement() + " where fk_profilereference = ?", new Object[]{id});
    }

    private void createNewReusablePeriod(CounterConfiguration counterConfiguration, DateTime dateTime, CounterBalance result) {
        this.periodManager.calculatePeriod(counterConfiguration, result, dateTime);
        BigDecimal defaultValue = counterConfiguration.getDefaultValue() != null ? counterConfiguration.getDefaultValue() : BigDecimal.ZERO;
        result.setCommittedBalance(defaultValue);
        result.setTotalBalance(defaultValue);
        this.update(result);
        this.expireReservations(result);
    }

    private void expireReservations(CounterBalance result) {
        this.counterBalanceReservationDAO.findActiveReservationsForCounterBalanceId(result.getId()).forEach(reservation -> {
            reservation.setStatus(CounterBalanceReservation.Status.EXPIRED);
            this.counterBalanceReservationDAO.updateCounterBalanceReservation((CounterBalanceReservation)((Object)reservation));
        });
    }

    private DateTime calculateObsoleteDate(DateTime endDate) {
        DateTime now = DateTime.now();
        if (endDate == null || Months.monthsBetween(now, endDate).getMonths() > 18) {
            return now.plusMonths(18);
        }
        if (endDate.monthOfYear().equals(now.monthOfYear())) {
            return endDate.plusMonths(1).withDayOfMonth(1);
        }
        return endDate;
    }

    private DateTime calculateUpdatedObsoleteDate(DateTime currentObsoleteDate, DateTime newEndDate) {
        if ((newEndDate == null || currentObsoleteDate.isBefore(newEndDate)) && Months.monthsBetween(DateTime.now(), currentObsoleteDate).getMonths() < 12) {
            return currentObsoleteDate.plusMonths(12);
        }
        return currentObsoleteDate;
    }

    private CounterBalance findMatchingCounterBalance(CounterConfiguration counterConfiguration, long referenceKey, Timestamp sqlTimestamp) {
        long counterType = this.getCounterType(counterConfiguration);
        return (CounterBalance)this.find(this.getSelectStatement() + " where    (startdatetime is null or startdatetime <= ?)        and    (enddatetime is null or enddatetime > ?)        and    fk_counterconfiguration = ?        and    fk_profilereference = ?       and    counterType = ?", new Object[]{sqlTimestamp, sqlTimestamp, counterConfiguration.getId(), referenceKey, counterType});
    }

    private CounterBalance findLatestReusableBalance(CounterConfiguration counterConfiguration, long referenceKey) {
        long counterType = this.getCounterType(counterConfiguration);
        return (CounterBalance)this.find(this.getSelectStatement() + " where    fk_counterconfiguration = ?        and    fk_profilereference = ?        and    counterType = ? order by    startDatetime desc", new Object[]{counterConfiguration.getId(), referenceKey, counterType});
    }

    private void cacheNullRatingCounter(CounterConfiguration counterConfiguration, Long profileReference) {
        if (counterConfiguration.getCounterType() == RatingCounterType.RATING_VALUE) {
            this.cache.update(this.generateCacheKey(counterConfiguration.getId(), profileReference, this.getCounterType(counterConfiguration)), NULL_CACHE);
        }
    }

    private boolean isAfter(DateTime dateTime, DateTime startDateTime) {
        return startDateTime != null && startDateTime.isAfter(dateTime);
    }

    private boolean isBefore(DateTime dateTime, DateTime endDateTime) {
        return endDateTime != null && endDateTime.isBefore(dateTime);
    }

    private long getCounterType(CounterConfiguration counterConfiguration) {
        return counterConfiguration.getCounterConfigurationType() == CounterConfiguration.CounterConfigurationType.INDIVIDUAL ? 0L : 1L;
    }

    public String[] getColumns() {
        return (String[])Arrays.stream(TableColumn.values()).map(Enum::name).toArray(String[]::new);
    }

    public String getTableName() {
        return TABLE_NAME;
    }

    public String getSequenceName() {
        return TABLE_SEQUENCE_NAME;
    }

    public boolean isVersionable() {
        return true;
    }

    public boolean isUpdatable() {
        return true;
    }

    protected String getEntitySimpleName() {
        return CounterConfiguration.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 3;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1 || fingerprintVersion == 2) {
            return new Object[]{resultSet.getTimestamp(TableColumn.STARTDATETIME.name()), resultSet.getTimestamp(TableColumn.ENDDATETIME.name()), resultSet.getLong(TableColumn.FK_COUNTERCONFIGURATION.name()), resultSet.getLong(TableColumn.FK_PROFILEREFERENCE.name()), resultSet.getBigDecimal(TableColumn.TOTALBALANCE.name()), resultSet.getBigDecimal(TableColumn.COMMITTEDBALANCE.name()), resultSet.getBigDecimal(TableColumn.TOTALDISCOUNT.name()), resultSet.getTimestamp(TableColumn.INITTIMESTAMP.name()), resultSet.getLong(TableColumn.COUNTERTYPE.name()), resultSet.getTimestamp(TableColumn.OBSOLETEDATE.name())};
        }
        if (fingerprintVersion == 3) {
            return new Object[]{resultSet.getTimestamp(TableColumn.STARTDATETIME.name()), resultSet.getTimestamp(TableColumn.ENDDATETIME.name()), resultSet.getLong(TableColumn.FK_COUNTERCONFIGURATION.name()), resultSet.getLong(TableColumn.FK_PROFILEREFERENCE.name()), resultSet.getBigDecimal(TableColumn.TOTALBALANCE.name()), resultSet.getBigDecimal(TableColumn.COMMITTEDBALANCE.name()), resultSet.getBigDecimal(TableColumn.TOTALDISCOUNT.name()), resultSet.getTimestamp(TableColumn.INITTIMESTAMP.name()), resultSet.getLong(TableColumn.COUNTERTYPE.name()), resultSet.getTimestamp(TableColumn.OBSOLETEDATE.name()), resultSet.getBoolean(TableColumn.LIMITPERSONALIZED.name())};
        }
        return null;
    }

    private static enum TableColumn {
        ID,
        STARTDATETIME,
        ENDDATETIME,
        FK_COUNTERCONFIGURATION,
        FK_PROFILEREFERENCE,
        TOTALBALANCE,
        COMMITTEDBALANCE,
        TOTALDISCOUNT,
        INITTIMESTAMP,
        COUNTERTYPE,
        OBSOLETEDATE,
        LIMITPERSONALIZED,
        FINGERPRINT,
        FINGERPRINTVERSION,
        FINGERPRINTKEYGENERATION,
        VERSION;


        int index() {
            return this.ordinal();
        }
    }
}

