/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.persistence;

import com.ericsson.em.emc.hierarchies.persistence.Period;
import com.ericsson.lwac.cache.Cacheable;
import jakarta.persistence.Entity;
import java.io.Serializable;
import java.math.BigDecimal;
import org.joda.time.DateTime;

@Entity
public class CounterBalance
extends Period
implements Serializable,
Cacheable<CounterBalance> {
    public static final int INDIVIDUAL_COUNTER_TYPE = 0;
    public static final int SHARED_COUNTER_TYPE = 1;
    private static final long serialVersionUID = 1L;
    private long counterConfigurationId;
    private long referenceId;
    private BigDecimal totalBalance;
    private BigDecimal committedBalance;
    private BigDecimal totalDiscount;
    private DateTime initTimestamp;
    private long counterType;
    private DateTime obsoleteDate;
    private boolean limitPersonalized;
    private long version = 1L;

    public CounterBalance() {
    }

    private CounterBalance(CounterBalance counterBalance) {
        super(counterBalance);
        this.counterConfigurationId = counterBalance.counterConfigurationId;
        this.referenceId = counterBalance.referenceId;
        this.totalBalance = counterBalance.totalBalance;
        this.committedBalance = counterBalance.committedBalance;
        this.totalDiscount = counterBalance.totalDiscount;
        this.initTimestamp = counterBalance.initTimestamp;
        this.counterType = counterBalance.counterType;
        this.obsoleteDate = counterBalance.obsoleteDate;
        this.limitPersonalized = counterBalance.limitPersonalized;
        this.version = counterBalance.version;
    }

    public BigDecimal getTotalBalance() {
        return this.totalBalance;
    }

    void setTotalBalance(BigDecimal totalBalance) {
        this.totalBalance = totalBalance;
    }

    public BigDecimal getCommittedBalance() {
        return this.committedBalance;
    }

    void setCommittedBalance(BigDecimal committedBalance) {
        this.committedBalance = committedBalance;
    }

    public void setCounterType(long counterType) {
        this.counterType = counterType;
    }

    public long getCounterType() {
        return this.counterType;
    }

    public long getCounterConfigurationId() {
        return this.counterConfigurationId;
    }

    void setCounterConfigurationId(long counterConfigurationId) {
        this.counterConfigurationId = counterConfigurationId;
    }

    public long getReferenceId() {
        return this.referenceId;
    }

    void setReferenceId(long referenceId) {
        this.referenceId = referenceId;
    }

    public BigDecimal getTotalDiscount() {
        return this.totalDiscount;
    }

    void setTotalDiscount(BigDecimal totalDiscount) {
        this.totalDiscount = totalDiscount;
    }

    public String toString() {
        return "com.ericsson.mpah.hierarchies.persistence.CounterBalance[id=" + this.mId + "]";
    }

    public void updateTotalBalance(BigDecimal amount) {
        this.totalBalance = this.totalBalance.add(amount);
    }

    public void updateCommittedBalance(BigDecimal amount) {
        this.committedBalance = this.committedBalance.add(amount);
    }

    public void updateTotalDiscount(BigDecimal amount) {
        this.totalDiscount = this.totalDiscount.add(amount);
    }

    protected void validate() {
    }

    public void resetTotalBalance(BigDecimal amount) {
        this.totalBalance = amount;
    }

    public void resetCommittedBalance(BigDecimal amount) {
        this.committedBalance = amount;
    }

    public DateTime getInitTimestamp() {
        return this.initTimestamp;
    }

    public void setInitTimestamp(DateTime initTimestamp) {
        this.initTimestamp = initTimestamp;
    }

    public DateTime getObsoleteDate() {
        return this.obsoleteDate;
    }

    public void setObsoleteDate(DateTime obsoleteDate) {
        this.obsoleteDate = obsoleteDate;
    }

    public void setLimitPersonalized(boolean limitPersonalized) {
        this.limitPersonalized = limitPersonalized;
    }

    public boolean isLimitPersonalized() {
        return this.limitPersonalized;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void increaseVersion() {
        ++this.version;
    }

    void setVersion(long version) {
        this.version = version;
    }

    @Override
    public CounterBalance deepClone() {
        return new CounterBalance(this);
    }

    public CounterBalance copyToReferenceId(long referenceId) {
        CounterBalance targetCounterBalance = new CounterBalance(this);
        targetCounterBalance.setVersion(1L);
        targetCounterBalance.mId = null;
        targetCounterBalance.setReferenceId(referenceId);
        return targetCounterBalance;
    }

    public void updateBalance(CounterBalance counterBalance) {
        this.updateTotalBalance(counterBalance.getTotalBalance());
        this.updateCommittedBalance(counterBalance.getCommittedBalance());
        this.updateTotalDiscount(counterBalance.getTotalDiscount());
    }

    public static enum Type {
        TOTAL_BALANCE,
        COMMITTED_BALANCE;

    }
}

