/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.limits;

import com.ericsson.em.emc.hierarchies.Unit;
import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public final class LimitMatchingParameters {
    private final Optional<String> name;
    private final Optional<String> type;
    private final Optional<String> operationType;
    private final Optional<Unit> unit;
    private final Map<String, Predicate<String>> propertyToMatchPredicates;

    protected LimitMatchingParameters(String name, String type, String operationType, Unit unit, Map<String, Predicate<String>> matchers) {
        this.name = Optional.ofNullable(name);
        this.type = Optional.ofNullable(type);
        this.operationType = Optional.ofNullable(operationType);
        this.unit = Optional.ofNullable(unit);
        this.propertyToMatchPredicates = matchers;
    }

    public boolean shallMatchOnType() {
        return this.type.isPresent();
    }

    public boolean shallMatchOnOperationType() {
        return this.operationType.isPresent();
    }

    public boolean shallMatchOnUnit() {
        return this.unit.isPresent();
    }

    public boolean shallMatchOnName() {
        return this.name.isPresent();
    }

    public String getType() {
        return this.type.get();
    }

    public String getOperationType() {
        return this.operationType.get();
    }

    public Unit getUnit() {
        return this.unit.get();
    }

    public String getName() {
        return this.name.get();
    }

    Map<String, Predicate<String>> getPropertyToMatchPredicates() {
        return this.propertyToMatchPredicates;
    }

    public String toString() {
        MoreObjects.ToStringHelper tsh = MoreObjects.toStringHelper(this).add("name", this.name).add("type", this.type).add("operationType", this.operationType).add("unit", this.unit);
        for (Map.Entry<String, Predicate<String>> entry : this.propertyToMatchPredicates.entrySet()) {
            tsh.add(CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_CAMEL).convert(entry.getKey()), entry.getValue());
        }
        return tsh.toString();
    }

    public static abstract class Builder<T extends Builder<T>> {
        String name;
        String type;
        String operationType;
        Unit unit;
        Map<String, Predicate<String>> propertyToMatchPredicates = Maps.newHashMap();
        private final T self = this;

        public T matchOnType(String type) {
            this.type = type;
            return this.self;
        }

        public T matchOnTransferType(String operationType) {
            this.operationType = operationType;
            return this.self;
        }

        public T matchOnUnit(Unit unit) {
            this.unit = unit;
            return this.self;
        }

        public T matchOnName(String name) {
            this.name = name;
            return this.self;
        }

        protected T matchOnProperty(String key, String value) {
            return this.matchOnProperty(key, (String matchRuleValue) -> "*".equalsIgnoreCase((String)matchRuleValue) || matchRuleValue.equals(value));
        }

        protected T matchOnProperty(String key, Predicate<String> matcher) {
            this.propertyToMatchPredicates.put(key, matcher);
            return this.self;
        }

        public LimitMatchingParameters get() {
            return new LimitMatchingParameters(this.name, this.type, this.operationType, this.unit, this.propertyToMatchPredicates);
        }
    }
}

