/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.globalparameters;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.ericsson.em.emc.hierarchies.globalparameters.GlobalParameterManager;
import com.ericsson.em.emc.hierarchies.persistence.GlobalParameter;
import com.ericsson.em.validators.IsASCIISimpleString;
import com.ericsson.em.validators.IsRestrictedString;
import com.ericsson.lwac.cli.ExecutionException;
import com.ericsson.lwac.cli.RemoteCLIEnvironment;
import com.ericsson.lwac.cli.commands.Command;
import com.ericsson.lwac.cli.commands.RemoteAction;
import com.ericsson.lwac.cli.commands.RemoteCommand;
import jakarta.ejb.EJB;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@Command(name="globalparameters", group="common")
@Parameters(separators="=")
@RemoteCommand
public class GlobalParameterCliCommand {
    @EJB
    private GlobalParameterManager globalParameterManager;

    @Command(name="create")
    @Parameters(separators="=")
    private class CreateCommand
    implements RemoteAction {
        @Parameter(description="key", required=true, names={"--key"})
        @IsASCIISimpleString
        private String key;
        @Parameter(description="value", required=true, names={"--value"})
        @IsRestrictedString
        private String value;
        @Parameter(description="type", names={"--type"})
        @IsRestrictedString
        private String type;

        private CreateCommand() {
        }

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            if (this.type == null || this.type.isEmpty()) {
                this.type = "String";
            }
            GlobalParameterCliCommand.this.globalParameterManager.create(this.key, this.value, this.type);
            environment.getOutputWriter().printf("%s has been successfully created.", this.key).println();
        }
    }

    @Command(name="update")
    @Parameters(separators="=")
    private class UpdateCommand
    implements RemoteAction {
        @Parameter(description="key", required=true, names={"--key"})
        @IsASCIISimpleString
        private String key;
        @Parameter(description="value", required=true, names={"--value"})
        @IsRestrictedString
        private String value;

        private UpdateCommand() {
        }

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            GlobalParameterCliCommand.this.globalParameterManager.update(this.key, this.value);
            environment.getOutputWriter().printf("%s has been successfully updated.", this.key).println();
        }
    }

    @Command(name="list")
    @Parameters(separators="=")
    private class ListCommand
    implements RemoteAction {
        private ListCommand() {
        }

        @Override
        public void execute(RemoteCLIEnvironment environment) throws ExecutionException {
            List<GlobalParameter> parameters = GlobalParameterCliCommand.this.globalParameterManager.list();
            Collections.sort(parameters, new Comparator<GlobalParameter>(this){

                @Override
                public int compare(GlobalParameter o1, GlobalParameter o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
            for (GlobalParameter parameter : parameters) {
                environment.getOutputWriter().printf("%s = %s (%s)", parameter.getKey(), parameter.getValue(), parameter.getDataType()).println();
            }
        }
    }
}

