/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.cli;

import com.ericsson.em.emc.hierarchies.cli.ProfileEventCommandManager;
import com.ericsson.em.emc.hierarchies.persistence.ProfileEventEntity;
import com.ericsson.em.emc.hierarchies.persistence.ProfileEventLoggerDAO;
import com.ericsson.em.emc.hierarchies.persistence.SafeProfileEventEntity;
import com.ericsson.em.emc.logging.audittrail.AuditTrailLog;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Singleton
public class ProfileEventCommandManagerBean
implements ProfileEventCommandManager {
    @EJB
    private ProfileEventLoggerDAO profileEventLoggerDAO;

    @Override
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ViewAuditTrailLogRecord", transactionType="ViewProfileEvents", flags={"forcelog"})
    @RolesAllowed(value={"ROLE_VIEW_PROFILE_CHANGE_LOG", "ROLE_ADMIN"})
    public List<ProfileEventEntity> printProfileEvents(String profileName, LocalDate localDate, int limit) {
        return this.profileEventLoggerDAO.findByProfileNameLimitResults(profileName, localDate, limit);
    }

    @Override
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ViewAuditTrailLogRecord", transactionType="ViewProfileEvents", flags={"forcelog"})
    @PermitAll
    public List<SafeProfileEventEntity> printProfileEventsNoUserId(String profileName, LocalDate localDate, int limit) {
        return this.profileEventLoggerDAO.findByProfileNameLimitResultsNoUserId(profileName, localDate, limit);
    }

    @Override
    @AuditTrailLog(recordType="com.ericsson.em.emc.audittrail.records.ViewAuditTrailLogRecord", transactionType="ViewLatestProfileUpdate", flags={"forcelog"})
    @RolesAllowed(value={"ROLE_VIEW_PROFILE_CHANGE_LOG", "ROLE_ADMIN"})
    public LocalDateTime getLastUpdateForProfile(String profileName) {
        return this.profileEventLoggerDAO.findLastUpdateByProfile(profileName);
    }
}

