/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies.authorization;

import com.ericsson.em.emc.hierarchies.HierarchyManager;
import com.ericsson.em.emc.hierarchies.authorization.HierarchyAuthorizationProviderHelper;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import com.ericsson.lwac.security.Permission;
import com.ericsson.lwac.security.authorization.AuthorizationErrorException;
import com.ericsson.lwac.security.authorization.AuthorizationFailedException;
import com.ericsson.lwac.security.session.Identity;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@Singleton
public class HierarchyAuthorizationProviderHelperBean
implements HierarchyAuthorizationProviderHelper {
    @EJB
    private HierarchyManager hierarchyManager;

    @Override
    public Set<Permission> getEffectivePermissions(String permission, Identity realUser, ProfileReference effectiveUser) throws AuthorizationFailedException, AuthorizationErrorException {
        Collection<Permission> realUserPermissions = realUser.getPermissions();
        ProfileService permissionFeature = this.hierarchyManager.findService(effectiveUser, "Permissions");
        Set<Permission> effectiveUserPermissions = this.getAllPermissions(permissionFeature, new HashSet<Permission>());
        Permission executeAsPermission = this.getPermissionByName(realUserPermissions, permission);
        if (executeAsPermission != null) {
            String effectiveUserProfileName = effectiveUser.getProfile().getName();
            for (Permission allowedProfile : executeAsPermission.getSubPermissions()) {
                if (!allowedProfile.getName().equals(effectiveUserProfileName)) continue;
                HashSet<Permission> result = new HashSet<Permission>();
                block1: for (Permission allowedPermission : allowedProfile.getSubPermissions()) {
                    for (Permission effectiveUserPermission : effectiveUserPermissions) {
                        if (!allowedPermission.equals(effectiveUserPermission)) continue;
                        result.add(effectiveUserPermission);
                        continue block1;
                    }
                }
                return result;
            }
        }
        String ahProfileName = effectiveUser.getProfile() != null ? effectiveUser.getProfile().getName() : "";
        throw new SecurityException(String.format("User (%s) does not have (%s) permission for profile (%s)", realUser.getUserId(), permission, ahProfileName));
    }

    @Override
    public Set<Permission> getEffectivePermissions(ProfileReference effectiveUser, String ... permissions) {
        ProfileService permissionFeature = this.hierarchyManager.findService(effectiveUser, "Permissions");
        Set<Permission> effectiveUserPermissions = this.getAllPermissions(permissionFeature, new HashSet<Permission>());
        HashSet<Permission> result = new HashSet<Permission>();
        block0: for (String desiredPermission : permissions) {
            for (Permission effectiveUserPermission : effectiveUserPermissions) {
                if (!effectiveUserPermission.getName().equals(desiredPermission)) continue;
                result.add(effectiveUserPermission);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public Set<Permission> getEffectivePermissions(ProfileReference effectiveUser) {
        ProfileService permissionFeature = this.hierarchyManager.findService(effectiveUser, "Permissions");
        return this.getAllPermissions(permissionFeature, new HashSet<Permission>());
    }

    private Permission getPermissionByName(Collection<Permission> permissions, String name) {
        for (Permission permission : permissions) {
            if (!permission.getName().equals(name)) continue;
            return permission;
        }
        return null;
    }

    private Set<Permission> getAllPermissions(ProfileService profileService, Set<Permission> permissions) {
        if (profileService != null) {
            for (ProfileService permission : profileService.getChildren()) {
                permissions.add(new Permission(permission.getName(), this.getAllPermissions(permission, new HashSet<Permission>())));
            }
        }
        return permissions;
    }
}

