/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.hierarchies;

import com.ericsson.em.emc.hierarchies.HierarchyManager;
import com.ericsson.em.emc.hierarchies.persistence.Profile;
import com.ericsson.em.emc.hierarchies.persistence.ProfileDAO;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import com.ericsson.em.emc.hierarchies.persistence.ProfileService;
import jakarta.ejb.EJB;
import jakarta.ejb.Singleton;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class HierarchyManagerBean
implements HierarchyManager {
    @EJB
    private ProfileDAO profileDAO;

    @Override
    public Profile findProfile(String name) {
        return this.profileDAO.findByName(name);
    }

    private ProfileService findService(ProfileService profileService, String name) {
        if (profileService.getName().equals(name)) {
            return profileService;
        }
        for (ProfileService childService : profileService.getChildren()) {
            ProfileService result = this.findService(childService, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private List<ProfileService> getProfileServices(ProfileService profileService) {
        ArrayList<ProfileService> result = new ArrayList<ProfileService>();
        result.add(profileService);
        for (ProfileService service : profileService.getChildren()) {
            result.addAll(this.getProfileServices(service));
        }
        return result;
    }

    @Override
    public ProfileService findService(ProfileReference profileReference, String name) {
        return this.findService(profileReference.getProfile(), name);
    }

    @Override
    public ProfileService findService(Profile profile, String name) {
        ProfileService result = null;
        if (profile != null) {
            for (ProfileService profileService : profile.getServices()) {
                result = this.findService(profileService, name);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    @Override
    public String findProperty(ProfileReference profileReference, String serviceName, String propertyName) {
        return this.findProperty(profileReference.getProfile(), serviceName, propertyName);
    }

    @Override
    public String findProperty(Profile profile, String serviceName, String propertyName) {
        ProfileService profileService = this.findService(profile, serviceName);
        String value = null;
        if (profileService != null) {
            value = profileService.getPropertyValue(propertyName);
        }
        return value;
    }

    @Override
    public ProfileService findService(String profileName, String serviceName) {
        return this.findService(this.findProfile(profileName), serviceName);
    }

    @Override
    public List<ProfileService> getProfileServices(Profile profile) {
        ArrayList<ProfileService> result = new ArrayList<ProfileService>();
        for (ProfileService profileService : profile.getServices()) {
            result.addAll(this.getProfileServices(profileService));
        }
        return result;
    }
}

