/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.externaladmininfo;

import com.ericsson.em.emc.admin.AdminIdentityType;
import com.ericsson.lwac.security.session.Identity;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExternalAdminIdentity
implements Serializable {
    private static final Pattern IDENTITY_PATTERN = Pattern.compile("ID:([\\S]*)/(\\w+)");
    private static final String MESSAGE_EXCEPTION_IDENTITY_MISSING = "External admin identity missing";
    private static final String MESSAGE_EXCEPTION_IDENTITY_FORMAT_ILLEGAL = "Illegal format of identity string, was ";
    private final String userId;
    private final AdminIdentityType identityType;

    public ExternalAdminIdentity(Builder builder) {
        this.userId = builder.userId;
        this.identityType = builder.identityType;
    }

    public static ExternalAdminIdentity createFrom(Identity identity) {
        return ExternalAdminIdentity.newBuilder().userId(identity.getUserId()).identityType(AdminIdentityType.valueOf(identity.getUserIdType())).build();
    }

    public String getUserId() {
        return this.userId;
    }

    public AdminIdentityType getIdentityType() {
        return this.identityType;
    }

    public String getIdentifier() {
        return String.format("ID:%s/%s", new Object[]{this.userId, this.identityType});
    }

    public static ExternalAdminIdentity create(String identity) {
        if (identity == null) {
            throw new IllegalArgumentException(MESSAGE_EXCEPTION_IDENTITY_MISSING);
        }
        Matcher matcher = IDENTITY_PATTERN.matcher(identity);
        if (matcher.matches() && matcher.groupCount() == 2) {
            return ExternalAdminIdentity.newBuilder().userId(matcher.group(1)).identityType(AdminIdentityType.valueOf(matcher.group(2))).build();
        }
        throw new IllegalArgumentException(MESSAGE_EXCEPTION_IDENTITY_FORMAT_ILLEGAL + identity);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String userId;
        private AdminIdentityType identityType;

        private Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder identityType(AdminIdentityType identityType) {
            this.identityType = identityType;
            return this;
        }

        public ExternalAdminIdentity build() {
            return new ExternalAdminIdentity(this);
        }
    }
}

