/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.credential.provider;

import com.ericsson.em.emc.CoreUserErrorCode;
import com.ericsson.em.emc.UserExceptionBuilder;
import com.ericsson.em.emc.credential.CredentialOwner;
import com.ericsson.em.emc.credential.CredentialTypeProvider;
import com.ericsson.em.emc.credential.persistence.Credential;
import com.ericsson.em.emc.credential.provider.AbstractCredentialProvider;
import com.ericsson.em.emc.pincode.PinCodePolicyCallback;
import com.ericsson.em.emc.pincode.PinCodeService;
import com.ericsson.lwac.deployer.ApplicationContext;
import jakarta.annotation.Resource;
import jakarta.ejb.Local;
import jakarta.ejb.Singleton;
import java.util.List;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Local(value={CredentialTypeProvider.class})
@Singleton
public class PincodeCredentialProvider
extends AbstractCredentialProvider
implements CredentialTypeProvider,
PinCodePolicyCallback {
    @Resource
    private ApplicationContext applicationContext;
    @Resource
    private PinCodeService pinCodeService;

    @Override
    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public void onPostConstruct() {
        this.getCredentialManager().registerCredentialTypeProvider("pincode", (CredentialTypeProvider)this.applicationContext.getThis());
    }

    @Override
    protected String getCredentialTypeName() {
        return "pincode";
    }

    @Override
    protected void authenticateCredential(CredentialOwner credentialOwner, Credential credential, String currentSecret) {
        if (!this.authenticate(credentialOwner, credential, currentSecret)) {
            throw new UserExceptionBuilder(CoreUserErrorCode.INCORRECT_PIN).create();
        }
    }

    @Override
    public boolean authenticate(CredentialOwner credentialOwner, Credential credential, String secret) {
        if (super.authenticate(credentialOwner, credential, secret)) {
            this.pinCodeService.validatePinCodeExpiry(credential, credentialOwner);
            return true;
        }
        return false;
    }

    @Override
    protected void validateSecret(CredentialOwner credentialOwner, String credentialSecret) {
        this.pinCodeService.validatePinCode(credentialOwner, credentialSecret, (PinCodePolicyCallback)this.applicationContext.getThis());
    }

    @Override
    public LocalDate getBirthDate(CredentialOwner credentialOwner) {
        return null;
    }

    @Override
    public List<String> getIdentificationNumbers(CredentialOwner credentialOwner) {
        return null;
    }
}

