/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.certificate;

import com.ericsson.em.emc.certificate.Certificate;
import com.ericsson.em.emc.certificate.CertificateDAO;
import com.ericsson.lwac.crypto.persistence.CryptoExtendedBaseEntityDAOBean;
import com.ericsson.lwac.crypto.securitymodule.persistence.CryptoKeys;
import com.ericsson.lwac.crypto.securitymodule.persistence.Validatable;
import com.ericsson.lwac.database.persistence.BaseEntity;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import jakarta.ejb.Singleton;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

@Validatable
@Singleton
@CryptoKeys(keyAliases={"emm.certificate.S"})
public class CertificateDAOBean
extends CryptoExtendedBaseEntityDAOBean<Certificate>
implements CertificateDAO {
    private static final String[] COLUMNS = new String[]{"id", "certificate", "hashedcertificate", "expirydate", "fingerprint", "fingerprintversion", "fingerprintkeygeneration"};
    private static final int CERTIFICATE_CURRENT_FINGERPRINT_VERSION = 1;
    public static final String CERTIFICATE_FINGERPRINT_KEY = "emm.certificate.S";

    protected int assign(BaseEntity baseEntity, PreparedStatement preparedStatement) throws SQLException {
        Certificate certificate = (Certificate)baseEntity;
        int i = 1;
        preparedStatement.setBytes(i++, certificate.getCertificate());
        preparedStatement.setBytes(i++, certificate.getHashedCertificate());
        preparedStatement.setObject(i++, (Object)certificate.getExpiryTime(), 93, 9);
        i = this.assignFingerprint(preparedStatement, i, new Object[]{certificate.getCertificate(), certificate.getHashedCertificate(), certificate.getExpiryTime()});
        return i;
    }

    protected void assign(BaseEntity baseEntity, ResultSet resultSet) throws SQLException {
        super.assign(baseEntity, resultSet);
        Certificate certificate = (Certificate)baseEntity;
        certificate.setCertificate(resultSet.getBytes("certificate"));
        certificate.setHashedCertificate(resultSet.getBytes("hashedcertificate"));
        certificate.setExpiryTime(resultSet.getTimestamp("expirydate"));
    }

    @Override
    public Certificate create(Certificate certificate) {
        return (Certificate)super.create((BaseEntity)certificate);
    }

    @Override
    public void delete(Certificate certificate) {
        super.delete((BaseEntity)certificate);
    }

    @Override
    public Certificate find(long id) {
        return (Certificate)super.find(id);
    }

    @Override
    public List<Certificate> findAll() {
        return this.findMultiple(this.getSelectStatement(), new Object[0]);
    }

    @Override
    public Certificate findbyHashedCertificate(byte[] hashedCertificate) {
        return (Certificate)this.find(this.getSelectStatement() + " where hashedcertificate = ?", new Object[]{hashedCertificate});
    }

    protected String getEntitySimpleName() {
        return Certificate.class.getSimpleName();
    }

    protected String getFingerprintKeyAlias() {
        return CERTIFICATE_FINGERPRINT_KEY;
    }

    protected int getFingerprintVersion() {
        return 1;
    }

    protected Object[] getFingerprintedObjectsFromResultSet(int fingerprintVersion, ResultSet resultSet) throws SQLException {
        if (fingerprintVersion == 1) {
            return new Object[]{resultSet.getBytes("certificate"), resultSet.getBytes("hashedcertificate"), resultSet.getTimestamp("expirydate")};
        }
        return null;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP"})
    public String[] getColumns() {
        return COLUMNS;
    }

    public String getSequenceName() {
        return "emm$certificate_seq";
    }

    public String getTableName() {
        return "emm$certificate";
    }

    public boolean isUpdatable() {
        return false;
    }

    public boolean isVersionable() {
        return false;
    }

    protected Certificate createManagedEntity() {
        return new Certificate();
    }
}

