/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.activator;

import com.ericsson.em.emc.activator.LegacyFingerPrintActivationManager;
import com.ericsson.em.emc.activator.ProfileServiceActivationManager;
import com.ericsson.em.emc.credential.CredentialTypeManager;
import com.ericsson.em.emc.hierarchies.globalparameters.GlobalParameterActivationManager;
import com.ericsson.lwac.ObjectHelperFactory;
import com.ericsson.lwac.application.ActivationException;
import com.ericsson.lwac.application.Activator;
import com.ericsson.lwac.versions.Version;
import jakarta.ejb.EJB;
import jakarta.ejb.Local;
import jakarta.ejb.Singleton;

@Singleton
@Local(value={Activator.class})
public class EmcActivator
implements Activator {
    private static final String FINGERPRINT_INTRODUCTION_VERSION = "11.3.0-rc1";
    private static final String ADMINTEAMS_INTRODUCTION_VERSION = "11.11.0-rc1";
    @EJB
    private GlobalParameterActivationManager globalParameterActivationManager;
    @EJB
    private LegacyFingerPrintActivationManager legacyFingerPrintActivationManager;
    @EJB
    private CredentialTypeManager credentialTypeManager;
    @EJB
    private ProfileServiceActivationManager profileServiceActivatonManager;

    @Override
    public void onActivate(Version previousVersion, Version newVersion) throws ActivationException {
        if (previousVersion == null && newVersion != null) {
            this.credentialTypeManager.createCredentialTypes("password", "pincode");
        }
        this.globalParameterActivationManager.updateGlobalParameterCache();
        Version introducedFingerPrint = ObjectHelperFactory.createVersionFactory().create(FINGERPRINT_INTRODUCTION_VERSION);
        if (previousVersion != null && introducedFingerPrint.compareTo(previousVersion) > 0) {
            this.legacyFingerPrintActivationManager.insertIntoLegacyFingerprintRecordsWithValidFingerprint();
        }
        Version introducedAdminTeams = ObjectHelperFactory.createVersionFactory().create(ADMINTEAMS_INTRODUCTION_VERSION);
        if (previousVersion != null && introducedAdminTeams.compareTo(previousVersion) > 0) {
            this.profileServiceActivatonManager.insertIntoProfileServicesWithNewAdminPermission();
        }
    }
}

