/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc.accountholder.authentication;

import com.ericsson.em.emc.hierarchies.counters.Modifier;
import com.ericsson.em.emc.hierarchies.counters.ModifierResponse;
import com.ericsson.em.emc.hierarchies.persistence.CounterConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ModifierConfiguration;
import com.ericsson.em.emc.hierarchies.persistence.ProfileReference;
import java.math.BigDecimal;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class AuthenticationFailedSoftLimitModifier
implements Modifier {
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final BigDecimal NO_SOFT_LIMIT = BigDecimal.ZERO;

    @Override
    public ModifierResponse execute(ModifierConfiguration softLimitConfiguration, ProfileReference profileReference, CounterConfiguration counterConfiguration, BigDecimal startValue, BigDecimal endValue, BigDecimal debitAmount) {
        ModifierResponse response;
        if (softLimitConfiguration.getStartValue().compareTo(NO_SOFT_LIMIT) == 0) {
            response = new ModifierResponse(ModifierResponse.Status.NOT_EXECUTED);
        } else if (endValue.compareTo(softLimitConfiguration.getStartValue()) >= 0) {
            response = new ModifierResponse(ModifierResponse.Status.EXECUTED);
            response.addData("login.failed.soft.threshold", "true");
            String suspensionDuration = softLimitConfiguration.getData();
            DateTime suspendedUntil = DateTime.now().plusMinutes(Integer.parseInt(suspensionDuration));
            response.addData("login.failed.soft.threshold.until", formatter.print(suspendedUntil));
        } else {
            response = new ModifierResponse(ModifierResponse.Status.NOT_EXECUTED);
        }
        return response;
    }
}

