/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.em.emc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class CsvEntry {
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_SEPARATOR = ',';
    private final List<String> values = new ArrayList<String>();

    public CsvEntry() {
    }

    public CsvEntry(List<String> values) {
        this.values.addAll(values);
    }

    public String toLine(char separator, char quoteCharacter) {
        StringBuffer sb = new StringBuffer();
        if (this.values != null) {
            for (int i = 0; i < this.values.size(); ++i) {
                if (i != 0) {
                    sb.append(separator);
                }
                sb.append(quoteCharacter);
                String value = this.values.get(i);
                value = value == null ? "" : value;
                String valueToWrite = this.stringContainsSpecialCharacters(value) ? this.processValue(value).toString() : value;
                sb.append(valueToWrite);
                sb.append(quoteCharacter);
            }
        }
        return sb.toString();
    }

    public String toLine() {
        return this.toLine(',', '\"');
    }

    private boolean stringContainsSpecialCharacters(String line) {
        return line.indexOf(34) != -1;
    }

    private StringBuilder processValue(String nextElement) {
        StringBuilder sb = new StringBuilder(128);
        for (int j = 0; j < nextElement.length(); ++j) {
            char nextChar = nextElement.charAt(j);
            if (nextChar == '\"') {
                sb.append('\"').append(nextChar);
                continue;
            }
            sb.append(nextChar);
        }
        return sb;
    }

    public List<String> getValues() {
        return this.values;
    }

    public int size() {
        return this.getValues().size();
    }

    public String readString(int index) {
        return this.getValues().get(index);
    }

    public Integer readInt(int index) {
        return Integer.parseInt(this.readString(index));
    }

    public BigDecimal readBigDecimal(int index) {
        return new BigDecimal(this.readString(index));
    }

    public void writeString(int index, String value) {
        this.values.add(index, value);
    }

    public void writeInteger(int index, Integer value) {
        Integer valueToWrite = this.getIntegerWriteValue(value);
        this.values.add(index, String.valueOf(valueToWrite));
    }

    public void writeBigDecimal(int index, BigDecimal value) {
        BigDecimal valueToWrite = this.getBigDecimalWriteValue(value);
        this.values.add(index, String.valueOf(valueToWrite));
    }

    public CsvEntry appendString(String value) {
        this.values.add(this.getStringWriteValue(value));
        return this;
    }

    public CsvEntry appendInteger(Integer value) {
        this.appendObject(this.getIntegerWriteValue(value));
        return this;
    }

    public CsvEntry appendBigDecimal(BigDecimal value) {
        this.appendObject(this.getBigDecimalWriteValue(value));
        return this;
    }

    public CsvEntry appendObject(Object value) {
        this.values.add(String.valueOf(value));
        return this;
    }

    private String getStringWriteValue(String value) {
        return this.getWriterValue(value, "");
    }

    private Integer getIntegerWriteValue(Integer value) {
        return this.getWriterValue(value, 0);
    }

    private BigDecimal getBigDecimalWriteValue(BigDecimal value) {
        return this.getWriterValue(value, BigDecimal.valueOf(0L));
    }

    private <T> T getWriterValue(T value, T defaulValue) {
        T valueToWrite = defaulValue;
        if (value != null) {
            valueToWrite = value;
        }
        return valueToWrite;
    }
}

