/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.charging.common.dataitem;

import com.ericsson.charging.common.dataitem.AbstractDataItem;
import ericsson.ere.integration.config.Configurable;
import ericsson.ere.integration.config.ConfigurationException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ListDataItem
extends AbstractDataItem
implements Configurable,
List<Object> {
    private static String TAG_VALUE = "Value";
    private static String ATTR_VALUE = "value";
    protected boolean isModified = false;
    protected List<Object> myList;

    public ListDataItem(List<Object> list) {
        this.myList = list;
        this.isModified = false;
    }

    @Override
    public Object getDataItem(Object reference) {
        return this;
    }

    @Override
    public Object getDataItem() {
        return this;
    }

    public List<Object> getList() {
        return this;
    }

    public void setValue(List<Object> list) {
        this.setDataItem(null, list);
        if (this.myListeners != null) {
            this.myListeners.firePropertyChange(null, null, this.myList);
        }
    }

    @Override
    public void reset() {
        this.isModified = false;
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.myListeners != null) {
            this.myListeners.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void setDataItem(Object object) {
        this.setDataItem(null, object);
    }

    @Override
    public void setDataItem(Object reference, Object object) {
        if (object instanceof List) {
            List<Object> oldList = this.myList;
            this.myList = (List)object;
            this.firePropertyChange("MODIFIED", oldList, object);
        } else if (reference instanceof Number) {
            int index = ((Number)reference).intValue();
            try {
                this.set(index, object);
                this.isModified = true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.isModified = true;
    }

    @Override
    protected boolean performSetDataItem(Object reference, Object object) {
        return false;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void init(Element element) throws ConfigurationException {
        NodeList valueList = element.getElementsByTagName(TAG_VALUE);
        for (int ii = 0; ii < valueList.getLength(); ++ii) {
            String value = ((Element)valueList.item(ii)).getAttribute(ATTR_VALUE);
            this.add(value);
            if (this.myListeners == null) continue;
            this.myListeners.firePropertyChange("ADD", null, value);
        }
    }

    public int getSize() {
        return this.myList.size();
    }

    @Override
    public boolean remove(Object o) {
        try {
            int index = this.myList.indexOf(o);
            Object oldObject = this.myList.get(index);
            boolean retBool = this.myList.remove(o);
            this.firePropertyChange("REMOVE", oldObject, o);
            return retBool;
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    @Override
    public boolean add(Object o) {
        if (this.myList.add(o)) {
            this.firePropertyChange("ADD", null, o);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.myList.contains(o);
    }

    @Override
    public int indexOf(Object o) {
        return this.myList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.myList.lastIndexOf(o);
    }

    @Override
    public Object remove(int index) {
        Object ro = this.myList.remove(index);
        this.firePropertyChange("REMOVE;" + index, null, ro);
        return ro;
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.myList.listIterator(index);
    }

    @Override
    public Object get(int index) {
        return this.myList.get(index);
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        this.myList.addAll(index, c);
        if (this.myList.addAll(index, c)) {
            this.firePropertyChange("ADD", null, c);
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.myList.retainAll(c)) {
            this.firePropertyChange("RETAIN", null, c);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.myList.removeAll(c)) {
            this.firePropertyChange("REMOVE", null, c);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<?> c) {
        if (this.myList.addAll(c)) {
            this.firePropertyChange("ADD", null, c);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.myList.containsAll(c);
    }

    @Override
    public Object set(int index, Object element) {
        Object ro = this.myList.set(index, element);
        this.firePropertyChange("SET;index", null, element);
        return ro;
    }

    @Override
    public void add(int index, Object element) {
        this.myList.add(index, element);
        this.firePropertyChange("ADD;index", null, element);
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.myList.toArray(a);
    }

    @Override
    public Object[] toArray() {
        return this.myList.toArray();
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        return this.myList.subList(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.myList.size();
    }

    @Override
    public void clear() {
        int index1 = this.myList.size() - 1;
        this.myList.clear();
        if (index1 >= 0) {
            this.firePropertyChange("CLEAR", null, null);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.myList.iterator();
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.myList.listIterator();
    }
}

